% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateExpression.R
\name{estimateExpression}
\alias{estimateExpression}
\title{Estimated Expression}
\usage{
estimateExpression(txdb, filelist, by = "gene", mode = "Union",
  singleEnd = TRUE, ignore.strand = TRUE, fragments = FALSE, ...)
}
\arguments{
\item{txdb}{Genomic annotation file}

\item{filelist}{A vector of sam file paths containing 4sU labeled sam files and unlabeled files}

\item{by}{In terms of genes or transcripts, the default is the gene}

\item{mode}{mode can be one of the pre-defined count methods such as "Union", "IntersectionStrict", or "IntersectionNotEmpty" or it a user supplied count function.}

\item{singleEnd}{(Default TRUE) A logical indicating if reads are single or paired-end.}

\item{ignore.strand}{A logical indicating if strand should be considered when matching}

\item{fragments}{(Default FALSE) A logical; applied to paired-end data only. fragments control which function is used to read the data which subsequently affects which records are included in counting.}

\item{...}{The parameters of the \code{\link{summarizeOverlaps}} method}
}
\value{
A list of expression
}
\description{
This function is used to calculate the expression value of the gene.
It includs total exon expression values, total intron expression values, labeled exon expression values, and labeled intron expression values.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
test_path <- file.path(system.file(package="pulseTD"),'extdata/test1.sorted.bam')
test_path2 <- file.path(system.file(package="pulseTD"),'extdata/test2.sorted.bam')
\donttest{rpkmres <- estimateExpression(txdb,c(test_path,test_path2), by='gene')}
data('rpkmres', package='pulseTD')
head(rpkmres$total_exp)
head(rpkmres$pre_exp)
}
\seealso{
Other parameters \code{\link{summarizeOverlaps}}
}
