% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rows.R
\name{slice_rows}
\alias{slice_rows}
\alias{unslice}
\title{Slice a data frame into groups of rows}
\usage{
slice_rows(.d, .cols = NULL)

unslice(.d)
}
\arguments{
\item{.d}{A data frame to slice or unslice.}

\item{.cols}{A character vector of column names or a numeric vector
of column positions. If \code{NULL}, the slicing attributes are
removed.}
}
\value{
A sliced or unsliced data frame.
}
\description{
\code{slice_rows()} is equivalent to dplyr's
\code{\link[dplyr]{group_by}()} command but it takes a vector of
column names or positions instead of capturing column names with
special evaluation. \code{unslice()} removes the slicing
attributes.
}
\seealso{
\code{\link{by_slice}()} and \code{\link[dplyr]{group_by}()}
}

