% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverb-safely.R
\name{safely}
\alias{safely}
\title{Wrap a function to capture errors}
\usage{
safely(.f, otherwise = NULL, quiet = TRUE)
}
\arguments{
\item{.f}{A function to modify, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{mean}.
\item An anonymous function, e.g. \verb{\\(x) x + 1} or \code{function(x) x + 1}.
\item A formula, e.g. \code{~ .x + 1}. Only recommended if you require backward
compatibility with olders version of R.
}}

\item{otherwise}{Default value to use when an error occurs.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them
as they occur?}
}
\value{
A function that takes the same arguments as \code{.f}, but returns
a different value, as described above.
}
\description{
Creates a modified version of \code{.f} that always succeeds. It returns a list
with components \code{result} and \code{error}. If the function succeeds, \code{result}
contains the returned value and \code{error} is \code{NULL}. If an error occurred,
\code{error} is an \code{error} object and \code{result} is either \code{NULL} or \code{otherwise}.
}
\section{Adverbs}{
This function is called an adverb because it modifies the effect of a
function (a verb). If you'd like to include a function created an adverb
in a package, be sure to read \link{faq-adverbs-export}.
}

\examples{
safe_log <- safely(log)
safe_log(10)
safe_log("a")

list("a", 10, 100) |>
  map(safe_log) |>
  transpose()

# This is a bit easier to work with if you supply a default value
# of the same type and use the simplify argument to transpose():
safe_log <- safely(log, otherwise = NA_real_)
list("a", 10, 100) |>
  map(safe_log) |>
  transpose() |>
  simplify_all()
}
\seealso{
Other adverbs: 
\code{\link{auto_browse}()},
\code{\link{compose}()},
\code{\link{insistently}()},
\code{\link{negate}()},
\code{\link{partial}()},
\code{\link{possibly}()},
\code{\link{quietly}()},
\code{\link{slowly}()}
}
\concept{adverbs}
