% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depcorr1.R
\name{depcorr1}
\alias{depcorr1}
\title{Compute Power for Comparing Two Dependent Correlations, One Variable in Common
Takes correlations and range of values}
\usage{
depcorr1(r1y, r2y, r12, nlow, nhigh, alpha = 0.05, tails = 2, by = 1)
}
\arguments{
\item{r1y}{Correlation between the first predictor and the dependent variable}

\item{r2y}{Correlation between the second predictor and the dependent variable}

\item{r12}{Correlation between the first predictor and the second predictor}

\item{nlow}{Starting sample size}

\item{nhigh}{Ending sample size}

\item{alpha}{Type I error (default is .05)}

\item{tails}{one or two-tailed tests (default is 2)}

\item{by}{Incremental increase in sample size from low to high}
}
\value{
Power for Comparing Dependent Correlations, One Variable in Common
}
\description{
Compute Power for Comparing Two Dependent Correlations, One Variable in Common
Takes correlations and range of values
}
\examples{
depcorr1(r1y=.3,r2y=.04,r12 = .2, nlow=100,nhigh=300,by=10, tails=2)
}
