% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_variable1.R
\name{px_figures}
\alias{px_figures}
\alias{px_figures.px}
\title{Change figures variable}
\usage{
px_figures(x, value, validate)

\method{px_figures}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. Name of variable to use as FIGRUES. If missing, the
current PX_FIGURES variable is returned.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or a character string
}
\description{
Inspect or change which variable is used as figures. The previous figures
variable is changed to STUB. There can only be one figures variable.
}
\examples{
x1 <- px(population_gl)

# Print FIGURES
px_figures(x1)

# Change 'age' to FIGURES variable, 'n' i changed to STUB
x2 <- px_figures(x1, 'age')
px_figures(x2)
px_stub(x2)
}
\seealso{
\code{\link{px_stub}} \code{\link{px_heading}}
}
