% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/px.R
\name{px_validate}
\alias{px_validate}
\title{Check px object}
\usage{
px_validate(x)
}
\arguments{
\item{x}{A supposed px object.}
}
\value{
A valid px object.
}
\description{
Runs a number of checks on px object to see if it is valid.
}
\details{
This check is run by default by all \verb{px_*} functions, but can be skipped by
using \code{validate = FALSE}. This can be useful on large px objects where the
checks are time consuming. Instead of validating on every modifying function
\code{px_validate()} can be run as the final step to validate the object.
}
\examples{
# Turn off validation for modifying functions, and manually
# run validation as final step in creating px object.
x1 <-
  px(population_gl, validate = FALSE) |>
  px_title("Test", validate = FALSE) |>
  px_validate()

}
