% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_api_paths.R, R/pxweb_interactive.R
\name{pxweb_api_name}
\alias{pxweb_api_name}
\alias{pxweb_api_name.url}
\alias{pxweb_api_name.pxweb}
\alias{pxweb_api_name.pxweb_api_catalogue_entry}
\alias{pxweb_api_name.pxweb_explorer}
\alias{pxweb_api_rootpath}
\alias{pxweb_api_rootpath.url}
\alias{pxweb_api_rootpath.pxweb}
\alias{pxweb_api_rootpath.pxweb_explorer}
\alias{pxweb_api_subpath}
\alias{pxweb_api_subpath.pxweb}
\alias{pxweb_api_subpath.pxweb_explorer}
\alias{pxweb_api_path}
\alias{pxweb_api_path.url}
\alias{pxweb_api_path.pxweb}
\alias{pxweb_api_path.pxweb_explorer}
\alias{pxweb_api_dbpath}
\alias{pxweb_api_dbpath.pxweb}
\alias{assert_path}
\alias{pxe_position_path}
\alias{pxe_metadata_path}
\title{Get the api name, rootpath, subpath, path or dbpath}
\usage{
pxweb_api_name(x)

\method{pxweb_api_name}{url}(x)

\method{pxweb_api_name}{pxweb}(x)

\method{pxweb_api_name}{pxweb_api_catalogue_entry}(x)

\method{pxweb_api_name}{pxweb_explorer}(x)

pxweb_api_rootpath(x)

\method{pxweb_api_rootpath}{url}(x)

\method{pxweb_api_rootpath}{pxweb}(x)

\method{pxweb_api_rootpath}{pxweb_explorer}(x)

pxweb_api_subpath(x, init_slash = TRUE, as_vector = FALSE)

\method{pxweb_api_subpath}{pxweb}(x, init_slash = TRUE,
  as_vector = FALSE)

\method{pxweb_api_subpath}{pxweb_explorer}(x, init_slash = TRUE,
  as_vector = FALSE)

pxweb_api_path(x, init_slash = TRUE, as_vector = FALSE)

\method{pxweb_api_path}{url}(x, init_slash = TRUE, as_vector = FALSE)

\method{pxweb_api_path}{pxweb}(x, init_slash = TRUE, as_vector = FALSE)

\method{pxweb_api_path}{pxweb_explorer}(x, init_slash = TRUE,
  as_vector = FALSE)

pxweb_api_dbpath(x, init_slash = TRUE, as_vector = FALSE)

\method{pxweb_api_dbpath}{pxweb}(x, init_slash = TRUE,
  as_vector = FALSE)

\method{pxweb_api_path}{pxweb_explorer}(x, init_slash = TRUE,
  as_vector = FALSE)

assert_path(x)

pxe_position_path(x, init_slash = TRUE, as_vector = FALSE,
  include_rootpath = FALSE)

pxe_metadata_path(x, as_vector = FALSE)
}
\arguments{
\item{x}{object to get the name or path for}

\item{init_slash}{should \code{subpath} and \code{path} start with a \code{/}. Default is \code{TRUE}.}

\item{as_vector}{should \code{subpath} and \code{path} be a vector split by /. Default is \code{FALSE}.}

\item{include_rootpath}{Should the rootpath be included? Default is FALSE}
}
\description{
Get the api name, rootpath, subpath, path or dbpath
}
\details{
The PXWEB API contain the following path:
API-NAME/API-VERSION/LANGUAGE/DATABASE-ID/<LEVELS>/TABLE-ID

The full url is made up by the \code{rootpath}, \code{subpath}, and \code{path}.
The \code{rootpath} is made up of the protocol and the API-NAME / hostname and protocol (if any).

The \code{subpath} contain the API-VERSION and LANGUAGE but can contain other parts as well. 
The subpath is the shortest the config can be called for. It can be seen as the base for the API.

The \code{dbpath}, the data base path, contain DATABASE-ID/<LEVELS>/TABLE-ID.

The \code{path}, is the standar path of an url, i.e. \code{subpath} + \code{dbpath}.

No path ends with slash, but \code{subpath} and \code{dbpath} may begin with slash,
see the parameters
}
\keyword{internal}
