% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMARC.R
\name{predict.qCBARuleModel}
\alias{predict.qCBARuleModel}
\title{Aplies qCBARuleModel}
\usage{
\method{predict}{qCBARuleModel}(object, newdata, testingType,
  loglevel = "WARNING", ...)
}
\arguments{
\item{object}{\link{qCBARuleModel} class instance}

\item{newdata}{data frame with data}

\item{testingType}{either \code{mixture} for multi-rule classification or \code{firstRule} for one-rule classification. Applicable only when model is loaded from file.}

\item{loglevel}{logger level from \code{java.util.logging}}

\item{...}{other arguments (currently not used)}
}
\value{
vector with predictions.
}
\description{
Applies \link{qcba} rule model on provided data. 
Automatically detects whether one-rule or  multi-rule classification is used
}
\examples{
allData <- datasets::iris[sample(nrow(datasets::iris)),]
trainFold <- allData[1:100,]
testFold <- allData[101:nrow(datasets::iris),]
rmCBA <- cba(trainFold, classAtt="Species")
rmqCBA <- qcba(cbaRuleModel=rmCBA, datadf=trainFold)
print(rmqCBA@rules)
prediction <- predict(rmqCBA,testFold)
acc <- CBARuleModelAccuracy(prediction, testFold[[rmqCBA@classAtt]])
message(acc)

}
\seealso{
\link{qcba}
}
