% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_reliability.R
\name{reliability}
\alias{reliability}
\title{Measurement model reliability and internal consistence}
\usage{
reliability(qcpm)
}
\arguments{
\item{qcpm}{is an  is an object of class \code{qcpm}}
}
\value{
\item{}{A table containing for each block the mode of measurement A  or B, 
and the number of indicators, Cronbach's alpha, Dillon-Goldstein's rho, Dijkstra-Henseler rho, 
and first and second eigenvalue of the indicators' correlation matrix}
}
\description{
The function \code{reliability} returns the classicial indices used in PLS-PM to assess 
the reliability and internal consistence of the measurement models (Hair et al. 2019). In 
order it provides: Cronbach's alpha, Dillon-Goldstein's rho, the Dijkstra-Henseler rho and 
first and second eigenvalue of the indicators' correlation matrix. The function also 
returns the mode of measurement (A  or B), and the number of indicators for each block.
}
\details{
The function only returns Dijkstra-Henseler rho values for quantile 0.5. When mode 
B is selected, or there are some intra-block inverse correlations, the Dijkstra-Henseler rho, 
Cronbach's alpha, and Dillon-Goldstein's rho are not calculated.
}
\examples{

# Example of QC-PM in Well-Being analysis
# model with three LVs and reflective indicators

# load library and dataset province
library(qcpm)
data(province)

# Define the model using laavan sintax. Use a set of regression formulas defining 
# firstly the structural model and then the measurement model
model <- "
# Structural model
EcoW ~ Edu
Health ~ Edu + EcoW

# Reflective measurement model
Edu =~ O22 + O23 + O24 + O25aa + O26 + O_27_28 + O_27_28_AA
EcoW =~ O41 + O44aa + O45 + O46aa + O42 + O43
Health =~  O11F + O11M + O12MEAN_aa
"

# Apply qcpm
well.qcpm = qcpm(model,province)
reliability(well.qcpm)   

}
\references{
Hair, J.F., Risher, J.J., Sarstedt, M., Ringle, C. M. (2019). When to 
use and how to report the results of PLS-SEM. \emph{European business review}, \bold{31(1)}, pp. 2-24.
doi: 10.1108/EBR-11-2018-0203

Sanchez, G. (2013) PLS Path Modeling with R Trowchez Editions. Berkeley, 2013. 
Available at \url{https://www.gastonsanchez.com/PLS_Path_Modeling_with_R.pdf}.
}
\seealso{
\code{\link{qcpm}}, \code{\link{assessment}}, \code{\link{boot}}, and 
\code{\link{summary}}
}
\author{
Cristina Davino, Pasquale Dolce, Giuseppe Lamberti, Domenico Vistocco
}
