\name{qcv}
\alias{qcv}
\title{Quick Character Vector}
\usage{
qcv(..., terms = NULL, space.wrap = FALSE, trailing = FALSE,
  leading = FALSE, split = " ", rm.blank = TRUE)
}
\arguments{
  \item{\ldots}{Character objects. Either \ldots or
  \code{terms} argument must be utilized.}

  \item{terms}{An optional argument to present the terms as
  one long character string.  This is useful if the split
  (separator) is not a comma (e.g., spaces are the term
  separators).}

  \item{space.wrap}{logical.  If \code{TRUE} wraps the
  vector of terms with a leading/trailing space.}

  \item{trailing}{logical.  If \code{TRUE} wraps the vector
  of terms with a trailing space.}

  \item{leading}{logical.  If \code{TRUE} wraps the vector
  of terms with a leading space.}

  \item{split}{Character vector of length one to use for
  splitting (i.e., the separator used in the vector).  For
  use with the argument \code{terms}.}

  \item{rm.blank}{logical.  If \code{TRUE} removes all
  blank spaces from the vector.}
}
\value{
Returns a character vector.
}
\description{
Create a character vector without the use of quotation
marks.
}
\examples{
\dontrun{
qcv(I, like, dogs)
qcv(terms = "I, like, dogs") #default separator is " "
qcv(terms = "I, like, dogs", split = ",")
qcv(terms = "I  like dogs")
qcv(I, like, dogs, space.wrap = TRUE)
qcv(I, like, dogs, trailing = TRUE)
qcv(I, like, dogs, leading = TRUE)
exclude(Top25Words, qcv(the, of, and))
qcv(terms = "mpg cyl  disp  hp drat    wt  qsec vs am gear carb")
}
}
\seealso{
\code{\link[base]{c}}
}
\keyword{character}

