\name{plot.sum_cmspans}
\alias{plot.sum_cmspans}
\title{Plot Summary Stats for a Summary of a cmspans Object}
\usage{
\method{plot}{sum_cmspans}(x, digits = 3, sep = ".", name.sep = "&",
  values = TRUE, high = "red", transpose = TRUE, plot = TRUE,
  facet.vars = "time", rev.codes = !transpose, rev.stats = !transpose,
  ...)
}
\arguments{
  \item{x}{The sum_cmspans object (the object produced by
  calling \code{summary} on a cmspans object)}

  \item{digits}{The number of digits displayed if
  \code{values} is \code{TRUE}.}

  \item{sep}{The character that was used in \code{paste2}
  to paste the columns.}

  \item{name.sep}{The character that was used to paste the
  column names.}

  \item{values}{logical.  If \code{TRUE} the cell values
  will be included on the heatmap.}

  \item{high}{The color to be used for higher values.}

  \item{transpose}{logical.  If \code{TRUE} the dataframe
  is rotated 90 degrees.}

  \item{plot}{logical.  If \code{TRUE} the plot will
  automatically plot. The user may wish to set to
  \code{FALSE} for use in knitr, sweave, etc. to add
  additional plot layers.}

  \item{facet.vars}{A character vector of names to facet
  by.  Default is \code{"time"}.}

  \item{rev.codes}{logical If \code{TRUE} the plotting
  order of the code groups is reversed.}

  \item{rev.stats}{logical If \code{TRUE} the plotting
  order of the code descriptive statistics is reversed.}

  \item{\dots}{Other arguments passed to qheat.}
}
\description{
Plots a heat map of summary statistics for sum_cmspans
objects (the object produced by calling \code{summary} on a
cmspans object).
}
\seealso{
\code{\link[qdap]{summary.cmspans}}
}

