% Generated by roxygen2 (4.0.0): do not edit by hand
\name{gantt_rep}
\alias{gantt_rep}
\title{Generate Unit Spans for Repeated Measures}
\usage{
gantt_rep(rm.var, text.var, grouping.var = NULL, units = "words",
  col.sep = "_", name.sep = "_")
}
\arguments{
\item{rm.var}{An optional single vector or list of 1 or 2 of repeated
measures to facet by.}

\item{text.var}{The text variable.}

\item{grouping.var}{The grouping variables. Also takes a single grouping
variable or a list of 1 or more grouping variables.}

\item{units}{The unit of measurement to analyze.  One of the strings
\code{"character"}, \code{"syllable"}, \code{"word"}, or \code{"sentence"}.}

\item{col.sep}{The character string to use to separate pasted variables in
the pasted columns.}

\item{name.sep}{The character string to use to separate column names of the
pasted columns.}
}
\value{
Returns a data frame of start and end times by repeated measure and
grouping variable(s)
}
\description{
Produces start and end times for occurrences for each repeated measure
condition.
}
\note{
For non-repeated measures data use \code{\link[qdap]{gantt}}.  For
more flexible plotting needs use \code{\link[qdap]{gantt_wrap}} over the
generic plotting method.
}
\examples{
\dontrun{
dat <- with(rajSPLIT, gantt_rep(act, dialogue, list(fam.aff, sex),
    units = "words", col.sep = "_"))
head(dat, 20)
plot(dat)

gantt_wrap(dat,  "fam.aff_sex",  facet.vars = "act",
    title = "Repeated Measures Gantt Plot",
    minor.line.freq = 25, major.line.freq = 100)

## Two facets variables
dat2 <- with(DATA2, gantt_rep(list(day, class), state, person,
    units = "words", col.sep = "_"))
head(dat2, 20)
plot(dat2)
}
}
\references{
Clark, W. & Gantt, H. (1922) The Gantt chart, a working
tool of management. New York, Ronald Press.
}
\seealso{
\code{\link[qdap]{gantt}},
\code{\link[qdap]{gantt_wrap}},
\code{\link[qdap]{gantt_plot}}
}
\keyword{Gantt}

