% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_words.R, R/as.tdm.R, R/wfm.R, R/word_list.R
\name{Filter.all_words}
\alias{Filter}
\alias{Filter.DocumentTermMatrix}
\alias{Filter.TermDocumentMatrix}
\alias{Filter.all_words}
\alias{Filter.character}
\alias{Filter.fswl}
\alias{Filter.fwl}
\alias{Filter.rfswl}
\alias{Filter.wfm}
\title{Filter}
\usage{
\method{Filter}{all_words}(x, min = 1, max = Inf, count.apostrophe = TRUE,
  stopwords = NULL, ignore.case = TRUE, ...)

\method{Filter}{TermDocumentMatrix}(x, min = 1, max = Inf,
  count.apostrophe = TRUE, stopwords = NULL, ignore.case = TRUE, ...)

\method{Filter}{DocumentTermMatrix}(x, min = 1, max = Inf,
  count.apostrophe = TRUE, stopwords = NULL, ignore.case = TRUE, ...)

Filter(x, min = 1, max = Inf, count.apostrophe = TRUE, stopwords = NULL,
  ignore.case = TRUE, ...)

\method{Filter}{wfm}(x, min = 1, max = Inf, count.apostrophe = TRUE,
  stopwords = NULL, ...)

\method{Filter}{character}(x, min = 1, max = Inf, count.apostrophe = TRUE,
  stopwords = NULL, ignore.case = TRUE, ...)

\method{Filter}{fwl}(x, min = 1, max = Inf, count.apostrophe = TRUE,
  stopwords = NULL, ignore.case = TRUE, ...)

\method{Filter}{fswl}(x, min = 1, max = Inf, count.apostrophe = TRUE,
  stopwords = NULL, ignore.case = TRUE, ...)

\method{Filter}{rfswl}(x, min = 1, max = Inf, count.apostrophe = TRUE,
  stopwords = NULL, ignore.case = TRUE, ...)
}
\arguments{
\item{x}{A filterable object (e.g., \code{\link[qdap]{wfm}},
\code{\link[base]{character}}).}

\item{min}{Minimum word length.}

\item{max}{Maximum word length.}

\item{count.apostrophe}{logical.  If \code{TRUE} apostrophes are counted as 
characters.}

\item{stopwords}{A vector of stop words to remove.}

\item{ignore.case}{logical.  If \code{TRUE} stopwords will be removed 
regardless of case (ignored if used on a \code{\link[qdap]{wfm}}).}

\item{\ldots}{Other arguments passed to specific Filter methods.}
}
\value{
\code{Filter.all_words} - Returns a matrix of the class "all_words".

\code{Filter.TermDocumentMatrix} - Returns a matrix of the class "TermDocumentMatrix".

\code{Filter.DocumentTermMatrix} - Returns a matrix of the class "DocumentTermMatrix".

\code{Filter} - Returns a matrix of the class "wfm".

\code{Filter.character} - Returns a vector of the class "character".

\code{Filter.wfm} - Returns a matrix of the class "wfm".

\code{Filter.fwl} - Returns a matrix of the class "fwl".

\code{Filter.fswl} - Returns a matrix of the class "fswl".

\code{Filter.rfswl} - Returns a matrix of the class "rfswl".
}
\description{
\code{Filter.all_words} - Filter words from a all_words 
that meet max/min word length criteria.

\code{Filter.TermDocumentMatrix} - Filter words from a TermDocumentMatrix vector that meet 
max/min word length criteria.

\code{Filter.DocumentTermMatrix} - Filter words from a DocumentTermMatrix 
that meet max/min word length criteria.

\code{Filter} - Filter words from various objects that meet max/min word 
length criteria.

\code{Filter.wfm} - Filter words from a wfm that meet max/min word length 
criteria.

\code{Filter.character} - Filter words from a character vector that meet 
max/min word length criteria.

\code{Filter.fwl} - Filter words from a fwl 
that meet max/min word length criteria.

\code{Filter.fswl} - Filter words from a fswl 
that meet max/min word length criteria.

\code{Filter.rfswl} - Filter words from a rfswl 
that meet max/min word length criteria.
}
\details{
all_words Method for Filter

TermDocumentMatrix Method for Filter

DocumentTermMatrix Method for Filter

character Method for Filter

fwl Method for Filter

fswl Method for Filter

rfswl Method for Filter
}
\note{
The name and idea behind this function is inspired by the \pkg{dplyr}
package's \code{filter} function and has a similar meaning in that you are 
grabbing rows (or elements) meeting a particular criteria.
}
\examples{
\dontrun{
Filter(with(DATA, wfm(state, list(sex, adult))), 5)
with(DATA, wfm(state, list(sex, adult)))

## Filter particular words based on max/min values in wfm
v <- with(DATA, wfm(state, list(sex, adult)))
Filter(v, 5)
Filter(v, 5, count.apostrophe = FALSE)
Filter(v, 5, 7)
Filter(v, 4, 4)
Filter(v, 3, 4)
Filter(v, 3, 4, stopwords = Top25Words)

## Filter works on character strings too...
x <- c("Raptors don't like robots!",  "I'd pay $500.00 to rid them.")
Filter(x, 3)
Filter(x, 4)
Filter(x, 4, count.apostrophe = FALSE)
Filter(x, 4, count.apostrophe = FALSE, stopwords="raptors")
Filter(x, 4, stopwords="raptors")
Filter(x, 4, stopwords="raptors", ignore.case = FALSE)

DATA[, "state"] <- Filter(DATA[, "state"], 4)
DATA <- qdap::DATA

## Filter `all_words`
head(all_words(raj$dialogue))
Filter(head(all_words(raj$dialogue)), min = 3)
}
}

