% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_number}
\alias{rm_number}
\title{Remove/Replace/Extract Numbers}
\usage{
rm_number(text.var, trim = !extract, clean = TRUE, pattern = "@rm_number",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_number} uses the
\code{rm_number} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the numbers are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with number removed.
}
\description{
Remove/replace/extract number from a string (works on numbers with commas,
decimals and negatives).
}
\examples{
x <- c("-2 is an integer.  -4.3 and 3.33 are not.",
    "123,456 is a lot more than -.2",
    "hello world -.q")
rm_number(x)
rm_number(x, extract=TRUE)
}
\references{
The number regular expression was taken from:
\url{http://stackoverflow.com/a/5917250/1000343} authored by Justin Morgan.
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{number}

