% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_tag}
\alias{rm_tag}
\title{Remove/Replace/Extract Person Tags}
\usage{
rm_tag(text.var, trim = !extract, clean = TRUE, pattern = "@rm_tag",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_tag} uses the
\code{rm_tag} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the person tags are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with person tags removed.
}
\description{
Remove/replace/extract person tags from a string.
}
\details{
The default regex pattern \code{"(?<![@\\w])@([a-z0-9_]+)\\b"} is more liberal and
searches for the at (@) symbol followed by any word.  This can be accessed
via \code{pattern = "@rm_tag"}.
\href{https://support.twitter.com/articles/101299-why-can-t-i-register-certain-usernames}{Twitter}
user names are more constrained.  A second regex
(\code{"(?<![@\\w])@([a-z0-9_]{1,15})\\b"}) is provide that contains the
latter word to substring that begins with an at (@) followed by a word
composed of alpha-numeric characters and underscores, no longer than 15
characters.  This can be accessed via \code{pattern = "@rm_tag2"} (see
\bold{Examples}).
}
\examples{
x <- c("@hadley I like #rstats for #ggplot2 work.",
    "Difference between #magrittr and #pipeR, both implement pipeline operators for #rstats:
        http://renkun.me/r/2014/07/26/difference-between-magrittr-and-pipeR.html @timelyportfolio",
    "Slides from great talk: @ramnath_vaidya: Interactive slides from Interactive Visualization
        presentation #user2014. http://ramnathv.github.io/user2014-rcharts/#1",
    "tyler.rinker@gamil.com is my email",
    "A non valid Twitter is @abcdefghijklmnopqrstuvwxyz"
)

rm_tag(x)
rm_tag(rm_hash(x))
rm_tag(x, extract=TRUE)

## more restrictive Twitter regex
rm_tag(x, extract=TRUE, pattern="@rm_tag2")

## Remove only the @ sign
rm_tag(x, replacement = "\\\\3")
rm_tag(x, replacement = "\\\\3", pattern="@rm_tag2")
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{person}
\keyword{tag}
\keyword{twitter}

