% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rm_caps.R
\name{rm_caps}
\alias{rm_caps}
\title{Remove/Replace/Extract All Caps}
\usage{
rm_caps(text.var, trim = !extract, clean = TRUE, pattern = "@rm_caps",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_caps} uses the
\code{rm_caps} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the all caps strings are extracted
into a list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with "all caps" removed.
}
\description{
Remove/replace/extract 'all caps' words containing 2 or more consecutive
upper case letters from a string.
}
\examples{
x <- c("UGGG! When I use caps I am YELLING!")
rm_caps(x)
rm_caps(x, replacement="\\\\L\\\\1")
rm_caps(x, extract=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{rm_abbreviation}};
  \code{\link{rm_angle}}, \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{rm_caps_phrase}};
  \code{\link{rm_citation_tex}}; \code{\link{rm_citation}};
  \code{\link{rm_city_state_zip}};
  \code{\link{rm_city_state}}; \code{\link{rm_date}};
  \code{\link{rm_default}}; \code{\link{rm_dollar}};
  \code{\link{rm_email}}; \code{\link{rm_emoticon}};
  \code{\link{rm_endmark}}; \code{\link{rm_hash}};
  \code{\link{rm_nchar_words}}; \code{\link{rm_non_ascii}};
  \code{\link{rm_number}}; \code{\link{rm_percent}};
  \code{\link{rm_phone}}; \code{\link{rm_postal_code}};
  \code{\link{rm_repeated_characters}};
  \code{\link{rm_repeated_phrases}};
  \code{\link{rm_repeated_words}}; \code{\link{rm_tag}};
  \code{\link{rm_time}}; \code{\link{rm_title_name}};
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{rm_white}}, \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{rm_zip}}
}
\keyword{capital}
\keyword{caps}

