% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rm_zip.R
\name{rm_zip}
\alias{rm_zip}
\title{Remove/Replace/Extract Zip Codes}
\usage{
rm_zip(text.var, trim = !extract, clean = TRUE, pattern = "@rm_zip",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_zip} uses the
\code{rm_zip} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the zip codes are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with U.S. 5 and 5+4 zip codes removed.
}
\description{
Remove/replace/extract zip codes from a string.
}
\examples{
x <- c("Mr. Bean bought 2 tickets 2-613-213-4567",
  "43 Butter Rd, Brossard QC K0A 3P0 - 613 213 4567",
  "Rat Race, XX, 12345",
  "Ignore phone numbers(613)2134567",
  "Grab zips with dashes 12345-6789 or no space before12345-6789",
  "Grab zips with spaces 12345 6789 or no space before12345 6789",
  "I like 1234567 dogs"
)

rm_zip(x)
rm_zip(x, extract=TRUE)

## ======================= ##
## BUILD YOUR OWN FUNCTION ##
## ======================= ##

## example from: http://stackoverflow.com/a/26092576/1000343
zips <- data.frame(id = seq(1, 6),
    address = c("Company, 18540 Main Ave., City, ST 12345",
    "Company 18540 Main Ave. City ST 12345-0000",
    "Company 18540 Main Ave. City State 12345",
    "Company, 18540 Main Ave., City, ST 12345 USA",
    "Company, One Main Ave Suite 18540m, City, ST 12345",
    "company 12345678")
)

## Function to grab even if a character follows the zip

# paste together a more flexible regular expression
pat <- pastex(
    "@rm_zip",
    "(?<!\\\\d)\\\\d{5}(?!\\\\d)",
    "(?<!\\\\d)\\\\d{5}-\\\\d{4}(?!\\\\d)"
)
# Create your own function that extract is set to TRUE
rm_zip2 <- rm_(pattern=pat, extract=TRUE)
rm_zip2(zips$address)

## Function to extract just 5 digit zips

rm_zip3 <- rm_(pattern="(?<!\\\\d)\\\\d{5}(?!\\\\d)", extract=TRUE)
rm_zip3(zips$address)
}
\author{
\href{http://stackoverflow.com/}{stackoverflow's} hwnd and Tyler Rinker <tyler.rinker@gmail.com>.
}
\references{
The time regular expression was taken from:
\url{http://stackoverflow.com/a/25223890/1000343}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{rm_abbreviation}};
  \code{\link{rm_angle}}, \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{rm_caps_phrase}}; \code{\link{rm_caps}};
  \code{\link{rm_citation_tex}}; \code{\link{rm_citation}};
  \code{\link{rm_city_state_zip}};
  \code{\link{rm_city_state}}; \code{\link{rm_date}};
  \code{\link{rm_default}}; \code{\link{rm_dollar}};
  \code{\link{rm_email}}; \code{\link{rm_emoticon}};
  \code{\link{rm_endmark}}; \code{\link{rm_hash}};
  \code{\link{rm_nchar_words}}; \code{\link{rm_non_ascii}};
  \code{\link{rm_number}}; \code{\link{rm_percent}};
  \code{\link{rm_phone}}; \code{\link{rm_postal_code}};
  \code{\link{rm_repeated_characters}};
  \code{\link{rm_repeated_phrases}};
  \code{\link{rm_repeated_words}}; \code{\link{rm_tag}};
  \code{\link{rm_time}}; \code{\link{rm_title_name}};
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{rm_white}}, \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}
}
\keyword{zip}

