% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/escape.R
\name{escape}
\alias{escape}
\title{Escape Strings From Parsing}
\usage{
escape(pattern)
}
\arguments{
\item{pattern}{A character string that should not be parsed.}
}
\value{
Returns a character vector of the class "escape" and "character".
}
\description{
Escape literal beginning at (@) strings from \pkg{qdapRegex} parsing.
}
\details{
Many \pkg{qdapRegex} functions parse \code{pattern} strings
beginning with an at character (@) and comparing against the default and
supplemental (\code{\link[qdapRegex]{regex_supplement}}) dictionaries.  This
means that a string such as "@before_" will be returned as
"\\\\w+?(?= ((\%s|\%s)\\\\b))".  If the user wanted to use a regular
expression that was literally "@before_" the \code{escape} function classes
the character string and tells the \pkg{qdapRegex} functions not to parse it
(i.e., keep it as a literal string).
}
\examples{
escape("@rm_caps")

x <- "...character vector.  Default, \\\\code{@rm_caps} uses..."

rm_default(x, pattern = "@rm_caps")
rm_default(x, pattern = escape("@rm_caps"))
}
\keyword{escape}
\keyword{noparse}

