% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rm_time.R
\name{rm_time}
\alias{as_time}
\alias{as_time2}
\alias{ex_time}
\alias{ex_transcript_time}
\alias{rm_time}
\alias{rm_transcript_time}
\title{Remove/Replace/Extract Time}
\usage{
rm_time(text.var, trim = !extract, clean = TRUE, pattern = "@rm_time",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_transcript_time(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_transcript_time", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

as_time(x, as.POSIXlt = FALSE, millisecond = TRUE)

as_time2(x, ...)

ex_time(text.var, trim = !extract, clean = TRUE, pattern = "@rm_time",
  replacement = "", extract = TRUE,
  dictionary = getOption("regex.library"), ...)

ex_transcript_time(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_transcript_time", replacement = "", extract = TRUE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector (see \bold{Details} for additional information).  Default,
\code{@rm_time} uses the \code{rm_time} regex from the regular expression
dictionary from the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the times are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{x}{A list with extracted time stamps.}

\item{as.POSIXlt}{logical.  If \code{TRUE} the output will be converted to
\code{\link[base]{as.POSIXlt}}.}

\item{millisecond}{logical.  If \code{TRUE} milliseconds are retained.  If
\code{FALSE} they are rounded and added to seconds.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with time removed.
}
\description{
\code{rm_time} - Remove/replace/extract time from a string.

\code{rm_transcript_time} - Remove/replace/extract transcript specific time
stamps from a string.

\code{as_time} - Convert a time stamp removed by \code{rm_time} or
\code{rm_transcript_time} to a standard time format (HH:SS:MM.OS) and
optionally convert to \code{\link[base]{as.POSIXlt}}.

\code{as_time} - A convenience function for \code{as_time} that unlists and
returns a vector rather than a list.
}
\details{
The default regular expression used by \code{rm_time} finds
time with no AM/PM.  This behavior can be altered by using a
secondary regular expression from the \code{\link[qdapRegex]{regex_usa}}
data (or other dictionary) via (\code{pattern = "@rm_time2"}. See
\bold{Examples} for example usage.
}
\note{
\ldots in \code{as_time2} are the other arguments passed to \code{as_time}.
}
\examples{
x <-  c("R uses 1:5 for 1, 2, 3, 4, 5.",
    "At 3:00 we'll meet up and leave by 4:30:20",
    "We'll meet at 6:33.", "He ran it in :22.34")

rm_time(x)
ex_time(x)

## With AM/PM
x <- c(
    "I'm getting 3:04 AM just fine, but...",
    "for 10:47 AM I'm getting 0:47 AM instead.",
    "no time here",
    "Some time has 12:04 with no AM/PM after it",
    "Some time has 12:04 a.m. or the form 1:22 pm"
)

rm_time(x, extract=TRUE)
ex_time(x, pat="@rm_time2")
rm_time(x, pat="@rm_time2")
ex_time(x, pat=pastex("@rm_time2", "@rm_time"))

# Convert to standard format
as_time(ex_time(x))
as_time(ex_time(x), as.POSIXlt = TRUE)
as_time(ex_time(x), as.POSIXlt = FALSE, millisecond = FALSE)

# Transcript specific time stamps
x2 <-c(
    '08:15 8 minutes and 15 seconds	00:08:15.0',
    '3:15 3 minutes and 15 seconds	not 1:03:15.0',
    '01:22:30 1 hour 22 minutes and 30 seconds	01:22:30.0',
    '#00:09:33-5# 9 minutes and 33.5 seconds	00:09:33.5',
    '00:09.33,75 9 minutes and 33.5 seconds	00:09:33.75'
)

rm_transcript_time(x2)
(out <- ex_transcript_time(x2))

as_time(out)
as_time(out, TRUE)
as_time(out, millisecond = FALSE)

\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(chron)
lapply(as_time(out), chron::times)
lapply(as_time(out, , FALSE), chron::times)
}
}
\author{
\href{http://stackoverflow.com/}{stackoverflow's} hwnd and Tyler Rinker <tyler.rinker@gmail.com>.
}
\references{
The time regular expression was taken from:
\url{http://stackoverflow.com/a/25111133/1000343}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{as_numeric}},
  \code{\link{as_numeric2}}, \code{\link{ex_number}},
  \code{\link{rm_number}}; \code{\link{ex_abbreviation}},
  \code{\link{rm_abbreviation}}; \code{\link{ex_angle}},
  \code{\link{ex_bracket}},
  \code{\link{ex_bracket_multiple}},
  \code{\link{ex_curly}}, \code{\link{ex_round}},
  \code{\link{ex_square}}, \code{\link{rm_angle}},
  \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{ex_between}},
  \code{\link{ex_between_multiple}},
  \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{ex_caps_phrase}},
  \code{\link{rm_caps_phrase}}; \code{\link{ex_caps}},
  \code{\link{rm_caps}}; \code{\link{ex_citation_tex}},
  \code{\link{rm_citation_tex}}; \code{\link{ex_citation}},
  \code{\link{rm_citation}};
  \code{\link{ex_city_state_zip}},
  \code{\link{rm_city_state_zip}};
  \code{\link{ex_city_state}}, \code{\link{rm_city_state}};
  \code{\link{ex_date}}, \code{\link{rm_date}};
  \code{\link{ex_default}}, \code{\link{rm_default}};
  \code{\link{ex_dollar}}, \code{\link{rm_dollar}};
  \code{\link{ex_email}}, \code{\link{rm_email}};
  \code{\link{ex_emoticon}}, \code{\link{rm_emoticon}};
  \code{\link{ex_endmark}}, \code{\link{rm_endmark}};
  \code{\link{ex_hash}}, \code{\link{rm_hash}};
  \code{\link{ex_nchar_words}},
  \code{\link{rm_nchar_words}}; \code{\link{ex_non_ascii}},
  \code{\link{rm_non_ascii}}; \code{\link{ex_non_words}},
  \code{\link{rm_non_words}}; \code{\link{ex_percent}},
  \code{\link{rm_percent}}; \code{\link{ex_phone}},
  \code{\link{rm_phone}}; \code{\link{ex_postal_code}},
  \code{\link{rm_postal_code}};
  \code{\link{ex_repeated_characters}},
  \code{\link{rm_repeated_characters}};
  \code{\link{ex_repeated_phrases}},
  \code{\link{rm_repeated_phrases}};
  \code{\link{ex_repeated_words}},
  \code{\link{rm_repeated_words}}; \code{\link{ex_tag}},
  \code{\link{rm_tag}}; \code{\link{ex_title_name}},
  \code{\link{rm_title_name}};
  \code{\link{ex_twitter_url}}, \code{\link{ex_url}},
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{ex_white}}, \code{\link{ex_white_bracket}},
  \code{\link{ex_white_colon}},
  \code{\link{ex_white_comma}},
  \code{\link{ex_white_endmark}},
  \code{\link{ex_white_lead}},
  \code{\link{ex_white_lead_trail}},
  \code{\link{ex_white_multiple}},
  \code{\link{ex_white_punctuation}},
  \code{\link{ex_white_trail}}, \code{\link{rm_white}},
  \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{ex_zip}},
  \code{\link{rm_zip}}

Other rm_.functions: \code{\link{as_numeric}},
  \code{\link{as_numeric2}}, \code{\link{ex_number}},
  \code{\link{rm_number}}; \code{\link{ex_abbreviation}},
  \code{\link{rm_abbreviation}}; \code{\link{ex_angle}},
  \code{\link{ex_bracket}},
  \code{\link{ex_bracket_multiple}},
  \code{\link{ex_curly}}, \code{\link{ex_round}},
  \code{\link{ex_square}}, \code{\link{rm_angle}},
  \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{ex_between}},
  \code{\link{ex_between_multiple}},
  \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{ex_caps_phrase}},
  \code{\link{rm_caps_phrase}}; \code{\link{ex_caps}},
  \code{\link{rm_caps}}; \code{\link{ex_citation_tex}},
  \code{\link{rm_citation_tex}}; \code{\link{ex_citation}},
  \code{\link{rm_citation}};
  \code{\link{ex_city_state_zip}},
  \code{\link{rm_city_state_zip}};
  \code{\link{ex_city_state}}, \code{\link{rm_city_state}};
  \code{\link{ex_date}}, \code{\link{rm_date}};
  \code{\link{ex_default}}, \code{\link{rm_default}};
  \code{\link{ex_dollar}}, \code{\link{rm_dollar}};
  \code{\link{ex_email}}, \code{\link{rm_email}};
  \code{\link{ex_emoticon}}, \code{\link{rm_emoticon}};
  \code{\link{ex_endmark}}, \code{\link{rm_endmark}};
  \code{\link{ex_hash}}, \code{\link{rm_hash}};
  \code{\link{ex_nchar_words}},
  \code{\link{rm_nchar_words}}; \code{\link{ex_non_ascii}},
  \code{\link{rm_non_ascii}}; \code{\link{ex_non_words}},
  \code{\link{rm_non_words}}; \code{\link{ex_percent}},
  \code{\link{rm_percent}}; \code{\link{ex_phone}},
  \code{\link{rm_phone}}; \code{\link{ex_postal_code}},
  \code{\link{rm_postal_code}};
  \code{\link{ex_repeated_characters}},
  \code{\link{rm_repeated_characters}};
  \code{\link{ex_repeated_phrases}},
  \code{\link{rm_repeated_phrases}};
  \code{\link{ex_repeated_words}},
  \code{\link{rm_repeated_words}}; \code{\link{ex_tag}},
  \code{\link{rm_tag}}; \code{\link{ex_title_name}},
  \code{\link{rm_title_name}};
  \code{\link{ex_twitter_url}}, \code{\link{ex_url}},
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{ex_white}}, \code{\link{ex_white_bracket}},
  \code{\link{ex_white_colon}},
  \code{\link{ex_white_comma}},
  \code{\link{ex_white_endmark}},
  \code{\link{ex_white_lead}},
  \code{\link{ex_white_lead_trail}},
  \code{\link{ex_white_multiple}},
  \code{\link{ex_white_punctuation}},
  \code{\link{ex_white_trail}}, \code{\link{rm_white}},
  \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{ex_zip}},
  \code{\link{rm_zip}}
}
\keyword{time}

