\name{makeFitness}
\alias{makeFitness}
\title{Generate QFA fitnesses}
\description{
This function generates a variety of informative fitnesses from generalised logistic model parameters (K,r,g,v).  It takes a data frame as generated by the qfa.fit function and appends columns for Maximum Doubling Rate (MDR), Maximum Doubling Potential (MDP), Addinall et al. style fitness (MDRMDP), Doubling Time (DT), Area Under Curve (AUC).  Note that this model-based AUC is disinct from the model-free nAUC which is generated directly from observed data by the qfa.fit function.  The two versions of AUC should be very similar in the vast majority of cases, however. 
}
\usage{
makeFitness(results,AUCLim,dtmax)
}
\arguments{
  \item{results}{Data frame as output by qfa.fit function.}
  \item{AUCLim}{AUC is calculated by integrating the generalised logistic function between t=0 and t=AUCLim.  The default value is 5 days.}
  \item{dtmax}{Although doubling time is an attractive and popular growth phenotype, it is not well defined for dead cultures, which appear regularly in high-throughput screens (doubling time goes to infinity as growth rate goes to zero).  To get around this numerical difficulty, this function sets all calculated doubling times above dtmax equal to dtmax.  Default value is 25 hours.}
}
\keyword{makeFitness}