% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.1.R
\name{qspec.lwqs}
\alias{qspec.lwqs}
\title{Lag-Window-Quantile-Smoothing (LWQS) Estimator of Quantile Spectrum}
\usage{
qspec.lwqs(
  y,
  tau,
  y.qacf = NULL,
  M = NULL,
  method = c("gamm", "sp"),
  spar = "GCV",
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{y.qacf}{matrix or array of pre-calculated QACF (default = \code{NULL}: compute from \code{y} and \code{tau});
if \code{y.qacf} is supplied, \code{y} and \code{tau} can be left unspecified}

\item{M}{bandwidth parameter of lag window (default = \code{NULL}: quantile periodogram)}

\item{method}{smoothing method: \code{"gamm"} for \code{mgcv::gamm()} (default), 
\code{"sp"} for \code{stats::smooth.spline()}}

\item{spar}{smoothing parameter in \code{smooth.spline()} if \code{method = "sp"} (default = \code{"GCV"})}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing (default = \code{NULL})}
}
\value{
A list with the following elements:
  \item{spec}{matrix or array of quantile spectrum/cross-spectrum}
  \item{spec.lw}{matrix or array of quantile spectrum/cross-spectrum without quantile smoothing}
  \item{lw}{lag-window sequence}
  \item{qacf}{matrix or array of quantile autocovariance function if \code{y.qacf = NULL}}
}
\description{
This function computes lag-window-quantile-smoothing (LWQS) estimate of quantile spectrum/cross-spectrum 
from time series or quantile autocovariance function (QACF).
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qper.lwqs <- qspec.lwqs(cbind(y1,y2),tau,M=5,method="sp",spar=0.9)$spec
qfa.plot(ff[sel.f],tau,Re(y.qper.lwqs[1,1,sel.f,]))
}
