% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_diet.R
\name{est_diet}
\alias{est_diet}
\title{Estimate predator diet composition}
\usage{
est_diet(pred_sigs, pred_uniq_types, pred_loc, prey_sigs, prey_uniq_types,
  prey_loc, cc, space = 1, dist_meas = 1, gamma = 1, ind_boot = 100,
  mean_meth = 1, var_meth = 1, mean_boot = 100)
}
\arguments{
\item{pred_sigs}{A vector or matrix of predator signatures ready for
analysis, intended to be the object \code{sig_scale} returned by a call to
the function \code{\link{prep_sig}} with the predator data frame.}

\item{pred_uniq_types}{A character vector of the unique predator types,
intended to be the object \code{uniq_types} returned by a call to the
function \code{\link{prep_sig}} with the predator data frame.}

\item{pred_loc}{A vector or matrix giving the first and last locations of the
signatures of each predator type within \code{pred_sigs}, intended to be
the object \code{loc} returned by a call to the function
\code{\link{prep_sig}} with the predator data frame.}

\item{prey_sigs}{A matrix of prey signatures ready for analysis, intended to
be the object \code{sig_scale} returned by a call to the function
\code{\link{prep_sig}} with the prey data frame or the object
\code{sig_part} returned by \code{\link{make_prey_part}}.}

\item{prey_uniq_types}{A character vector of the unique prey types, intended
to be the object \code{uniq_types} returned by a call to the function
\code{\link{prep_sig}} with the prey data frame.}

\item{prey_loc}{A matrix giving the first and last locations of the
signatures of each prey type within \code{prey_sigs}, intended to be the
object \code{loc} returned by a call to the function
\code{\link{prep_sig}} with the prey data frame.}

\item{cc}{A vector of calibration coefficients, intended to be the object
\code{cc} returned by the function \code{\link{prep_fa}}.}

\item{space}{An integer indicator of the estimation space to be used. Default
value 1.}

\item{dist_meas}{An integer indicator of the distance measure to be used.
Default value 1.}

\item{gamma}{The power parameter of the chi-square distance measure. Default
value 1.}

\item{ind_boot}{The number of bootstrap replications to use in the estimation
of the variance of an individual predator's diet. Default value 100.}

\item{mean_meth}{An integer indicator of the estimation method for mean diet.
Default value 1.}

\item{var_meth}{An integer indicator of the estimation method for the
variance of mean diet. Default value 1 (bootstrap estimator).}

\item{mean_boot}{The number of bootstrap replications to use, needed only if
the bootstrap method of estimating the variance of meat diet is selected
(var_meth == 1). Default value 100.}
}
\value{
A list containing the following elements: \describe{
  \item{pred_sigs}{A numeric matrix of predator signatures, potentially
    transformed to the prey space.}
  \item{prey_sigs}{A numeric matrix of prey signatures, potentially
    transformed to the predator space.}
  \item{mean_sigs}{A numeric matrix of mean prey-type signatures, potentially
    transformed to the predator space.}
  \item{est_ind}{A numeric matrix of the estimated diet compositions of
    individual predators.}
  \item{conv}{A logical vector indicating whether the optimization function
    successfully converged.}
  \item{obj_func}{A numeric vector of the values of the objective function at
    each predator's estimated diet.}
  \item{mod_sigs}{A numeric matrix of the modeled signature of each predator
    at its estimated diet.}
  \item{var_ind}{A numeric array containing the estimated variance matrix for
    the estimated mean diet of each predator.}
  \item{est_mean}{A numeric matrix containing the estimated mean diet of each
    predator type.}
  \item{conv_mean}{A logical vector indicating whether the estimated mean
    diet of each predator type is based on at least one diet estimate that
    converged.}
  \item{var_mean}{A numeric array containing the estimated variance matrix
    for the estimated mean diet of each predator type.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
}
}
\description{
\code{est_diet} estimates the diet of one or more predators.
}
\section{Details}{

\code{est_diet} estimates the diet of one or more predators.  It implements a
variety of estimation options, and is therefore one of the more complicated
functions in \code{qfasar}.  Please read the following information and the
Diet Estimation section of the vignette for a description of the options.

The objects passed via the arguments \code{pred_sig}, \code{pred_uniq_types},
and \code{pred_loc} are presumed to be the objects \code{sig_scale},
\code{uniq_types}, and \code{loc}, respectively, returned by a call to the
function \code{\link{prep_sig}} with the predator data frame.

The objects passed via the arguments \code{prey_sig}, \code{prey_uniq_types},
and \code{prey_loc} are presumed to be the objects \code{sig_scale},
\code{uniq_types}, and \code{loc}, respectively, returned by a call to the
function \code{\link{prep_sig}} with the prey data frame.

The object passed via the argument \code{cc} is presumed to be the
object \code{cc} returned by a call to the function
\code{\link{prep_fa}} with the fatty acid suite data frame.

Bromaghin et al. (2015) introduced the terms \strong{prey space} and
\strong{predator space}. These terms refer to the simplexes in which the prey
and predator signatures reside. The spaces differ due to predator metabolism
of ingested prey tissue and the resulting modification of signature
proportions. The calibration coefficients \code{cc} provide a one-to-one
mapping or transformation between the prey and predator spaces.  Diet
estimation can be performed in either space. Iverson et al. (2004) used
calibration coefficients to map predator signatures to the prey space, while
Bromaghin et al. (2013) took the opposite approach and mapped prey signatures
to the predator space. Simulation work has not revealed any strong reason
to prefer one space over the other (Bromaghin et al. 2015). However, be aware
that some distance measures will produce different diet estimates in the two
spaces.  Please see the vignette for more information.

Estimation space options:
\itemize{
  \item space == 1 Estimation in the predator space, the default value.
  \item space == 2 Estimation in the prey space.
}

\code{qfasar} implements three distance measures that have been used by QFASA
practitioners and researchers: Aitchison, Kullback-Leibler, and chi-square.
The argument \code{gamma} is a parameter of the chi-square distance measure
and its value must be strictly greater than 0 and less than or equal to 1.
The distance measure options are:
\itemize{
\item dist_meas == 1 yields the Aitchison distance measure (Stewart et al.
  2014).  This is the default value.
\item dist_meas == 2 yields the Kullback-Leibler distance measure of
  Iverson et al. (2004).
\item dist_meas == 3 yields the chi-square distance measure (Stewart et
  al. 2014).
}
Please refer to the vignette for additional information about distance
measures.

The covariance matrix of each estimated diet can be estimated by bootstrap
sampling the prey library.  The signatures of each prey type are
independently sampled with replacement and the predator diet is
estimated with the bootstrapped library.  This is replicated \code{ind_boot}
times and the covariance matrix is estimated from the replicated estimates
(Beck et al. 2007, Bromaghin et al. 2015). If you do not wish to estimate
variances for the individual diet estimates, pass a bootstrap sample size
of 0 via the argument ind_boot.

\code{qfasar} implements two methods of estimating the mean diet of each
class of predator.  The first is the empirical mean of the estimated diets.
In the second method, called the \strong{parameterized mean} method, the
model is parameterized with a single vector of diet proportions common to all
predators and mean diet is estimated by minimizing the distance between the
signature modeled from the mean diet proportions and each predator's
observed signature, summed over all predators.  The parameterized mean method
has not yet been thoroughly tested and its inclusion is intended to
facilitate future research.  Our limited and unpublished work with the
parameterized mean estimator suggests it may perform well when predator
signatures are homogeneous, but may be more sensitive to the presence of
predators with quite different signatures than the empirical estimator.
The options for \code{mean_meth} are:
\itemize{
\item mean_meth == 0 skips estimation of mean diet.
\item mean_meth == 1 yields the empirical estimate of mean diet.  This is the
  default value.
\item mean_meth == 2 yields the parameterized mean estimate of mean diet.
}

\code{qfasar} implements two methods of estimating the variance of mean diet
estimates, the variance estimator of Beck et al. (2007) and a bootstrap
estimator, controlled by the argument \code{var_meth}.  The bootstrap
estimator draws independent samples of each prey type to form a bootstrap
prey library and a random sample of each predator type, with sample sizes
equal to the observed sample sizes.  Mean diet is estimated using the method
indicated by \code{mean_meth}.  The argument \code{mean_boot} controls the
number of times this is repeated, and the replications are used to estimate
the covariance matrix for each predator type. Unpublished work suggests
that the bootstrap estimator is more reliable. Note that if using the
parameterized-mean estimator for mean diet composition, the Beck estimator
is not appropriate.  The options for
\code{var_meth} are:
\itemize{
\item var_meth == 0 skips variance estimation for mean diets.
\item var_meth == 1 yields the bootstrap estimator.  This is the default
  value.
\item var_meth == 2 yields the Beck et al. (2007) estimator.
}

NOTE: The numerical optimization and bootstrap sampling performed by
\code{est_diet} are numerically intensive and can cause long runs times.
Patience is advised!  The primary factors causing slow execution are the
number of predator signatures, the number of predator and prey types, and
bootstrap sample sizes.
}

\section{References}{

Beck, C.A., S.J. Iverson, W.D. Bowen, and W. Blanchard. 2007. Sex differences
  in grey seal diet reflect seasonal variation in foraging behaviour and
  reproductive espenditure: evidence from quantitative fatty acid signature
  analysis. \emph{Journal of Animal Ecology} 76:490-502.

Bromaghin, J.F., M.M. Lance, E.W. Elliott, S.J. Jeffries, A.
  Acevedo-Gutierrez, and J.M. Kennish. 2013. New insights into the diets of
  harbor seals (\emph{Phoca vitulina}) in the Salish Sea revealed by analysis
  of fatty acid signatures. \emph{Fishery Bulletin} 111:13-26.

Bromaghin, J.F., K.D. Rode, S.M. Budge, and G.W. Thiemann. 2015. Distance
  measures and optimization spaces in quantitative fatty acid signature
  analysis. \emph{Ecology and Evolution} 5:1249-1262.

Iverson, S.J., C. Field, W.D. Bowen, and W. Blanchard. 2004.
  Quantitative fatty acid signature analysis: A new method of
  estimating predator diets. \emph{Ecological Monographs} 74:211-235.

Stewart, C., S. Iverson, and C. Field. 2014. Testing for a change in diet
  using fatty acid signatures. \emph{Environmental and Ecological Statistics}
  21:775-792.
}
\examples{
est_diet(pred_sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                              0.04, 0.11, 0.29, 0.56,
                              0.10, 0.06, 0.35, 0.49,
                              0.05, 0.15, 0.35, 0.45), ncol=4),
         pred_uniq_types = c("Pred_1", "Pred_2"),
         pred_loc = matrix(c(1, 3, 2, 4), ncol=2),
         prey_sigs = matrix(c(0.06, 0.09, 0.31, 0.54,
                              0.05, 0.09, 0.30, 0.56,
                              0.03, 0.10, 0.30, 0.57,
                              0.08, 0.07, 0.30, 0.55,
                              0.09, 0.05, 0.33, 0.53,
                              0.09, 0.06, 0.34, 0.51,
                              0.09, 0.07, 0.34, 0.50,
                              0.08, 0.11, 0.35, 0.46,
                              0.06, 0.14, 0.36, 0.44), ncol=9),
         prey_uniq_types = c("Prey_1", "Prey_2", "Prey_3"),
         prey_loc = matrix(c(1, 4, 7, 3, 6, 9), ncol=2),
         cc = c(0.75, 1.00, 1.50, 1.15),
         space = 1, dist_meas = 1, ind_boot = 2,
         mean_meth = 0)

}

