% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qdo.R
\name{qdo}
\alias{qdo}
\title{Manipulating the output of \code{mqgam}}
\usage{
qdo(obj, qu = NULL, fun = I, ...)
}
\arguments{
\item{obj}{the output of a \code{mqgam} call.}

\item{qu}{A vector whose elements must be in (0, 1). Each element indicates a quantile of interest, 
which should be an element of \code{names(obj$fit)}. If left to \code{NULL} the function
\code{fun} will be applied to each of the quantile fits in \code{obj}.}

\item{fun}{The method or function that we want to use on the \code{gamObject} corresponding to quantile \code{qu}. For instance
\code{predict}, \code{plot} or \code{summary}. By default this is the identity function (\code{I}), which
means that the fitted model for quantile \code{qu} is returned.}

\item{...}{Additional arguments to be passed to \code{fun}.}
}
\value{
A list where the i-th entry is the output of \code{fun} (whatever that is) corresponding to quantile \code{qu[i]}.
}
\description{
Contrary to \code{qgam}, \code{mqgam} does not output a standard \code{gamObject}, hence
             methods such as \code{predict.gam} or \code{plot.gam} cannot be used directly. \code{qdo}
             provides a simple wrapper for such methods.
}
\examples{
library(qgam); library(MASS)

quSeq <- c(0.4, 0.6)
set.seed(737)
fit <- mqgam(accel~s(times, k=20, bs="ad"), data = mcycle, err = 0.05, qu = quSeq, 
             control = list("tol" = 0.01)) # <- semi-sloppy tolerance to speed-up calibration 

qdo(fit, 0.4, summary)
invisible(qdo(fit, 0.4, plot, pages = 1))

# Return the object for qu = 0.6 and then plot it
tmp <- qdo(fit, 0.6)
plot(tmp)

}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>.
}
