% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{qgcomp}
\alias{qgcomp}
\title{estimation of quantile g-computation fit}
\usage{
qgcomp(f, data = data, family = gaussian(), rr = TRUE, ...)
}
\arguments{
\item{f}{R style formula}

\item{data}{data frame}

\item{family}{`gaussian()` or `binomial()`}

\item{rr}{logical: if using binary outcome and rr=TRUE, qgcomp.boot will 
estimate risk ratio rather than odds ratio. Note, to get population average 
effect estimates for a binary outcome, set rr=TRUE (default: ORs are generally not
of interest as population average effects, so if rr=FALSE then a conditional
OR will be estimated, which cannot be interpreted as a population average
effect}

\item{...}{arguments to qgcomp.noboot or qgcomp.boot (e.g. q)}
}
\value{
a qgcompfit object, which contains information about the effect
 measure of interest (psi) and associated variance (var.psi), as well
 as information on the model fit (fit) and possibly information on the 
 marginal structural model (msmfit) used to estimate the final effect
 estimates (qgcomp.boot only). If appropriate, weights are also reported.
}
\description{
This function automatically selects between qgcomp.noboot and qgcomp.boot
 to select the most efficient approach to estimate the average expected 
 change in the (log) outcome per quantile increase in the joint 
 exposure to all exposures in `expnms'
}
\examples{
set.seed(50)
dat <- data.frame(y=runif(50), x1=runif(50), x2=runif(50), z=runif(50))
qgcomp.noboot(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2)
qgcomp.boot(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2, B=10, seed=125)
# automatically selects appropriate method
qgcomp(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2)
# note for binary outcome this will 
dat <- data.frame(y=rbinom(50, 1, 0.5), x1=runif(50), x2=runif(50), z=runif(50))
qgcomp.noboot(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2, family=binomial())
qgcomp.boot(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2, B=10, seed=125, 
  family=binomial())
# automatically selects appropriate method
qgcomp(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2, family=binomial())
qgcomp(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2, family=binomial(), rr=TRUE)
}
\seealso{
\code{\link[qgcomp]{qgcomp.noboot}} and \code{\link[qgcomp]{qgcomp.boot}}
}
\keyword{mixtures}
\keyword{variance,}
