% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{pointwisebound.boot}
\alias{pointwisebound.boot}
\title{estimating pointwise comparisons for qgcomp.boot objects}
\usage{
pointwisebound.boot(x, alpha = 0.05, pointwiseref = 1)
}
\arguments{
\item{x}{"qgcompfit" object from `qgcomp.boot`,}

\item{alpha}{alpha level for confidence intervals}

\item{pointwiseref}{referent quantile (e.g. 1 uses the lowest joint-exposure category as 
the referent category for calculating all mean differences/standard deviations)}
}
\value{
A data frame containing expected values of the outcome at each quantized value
of all exposures as well as a mean difference contrasting the expected outcome at each
quantized value of all exposures, and associated standard error and confidence intervals.
}
\description{
Calculates: expected outcome (on the link scale), mean difference (link scale)
and the standard error of the mean difference (link scale) for pointwise comparisons
}
\details{
The comparison of interest following a qgcomp fit is often comparisons of model
predictions at various values of the joint-exposures (e.g. expected outcome at all exposures
at the 1st quartile vs. the 3rd quartile). The expected outcome at a given joint exposure is 
given as E(Y|S), where S takes on integer values 0 to q-1. Thus, comparisons are of the type
E(Y|S=s) - E(Y|S=s2) where s and s2 are two different values of the joint exposures (e.g. 0 and 2).
This function yields E(Y|S) as well as E(Y|S=s) - E(Y|S=p) where s is any value of S and p is
the value chosen via "pointwise ref" - e.g. for binomial variables this will equal the risk/
prevalence difference at all values of S, with the referent category S=p-1. The standard error
of E(Y|S=s) - E(Y|S=p) is calculated from the bootstrap covariance matrix of E(Y|S), such that 
the standard error for E(Y|S=s) - E(Y|S=p) is given by

Var(E(Y|S=s)) + - Var(E(Y|S=p)) - 2*Cov(E(Y|S=p), - E(Y|S=s))

This is used to create pointwise confidence intervals
}
\examples{
set.seed(12)
\donttest{
dat <- data.frame(x1=(x1 <- runif(50)), x2=runif(50), x3=runif(50), z=runif(50),
                  y=runif(50)+x1+x1^2)
ft <- qgcomp.boot(y ~ z + x1 + x2 + x3, expnms=c('x1','x2','x3'), data=dat, q=9)
pointwisebound.boot(ft, 5)
}
}
\seealso{
\code{\link[qgcomp]{qgcomp.boot}}
}
