% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_utility.R
\name{getjointeffects}
\alias{getjointeffects}
\title{Calculate joint effect of mixture effect and modifier vs. common referent}
\usage{
getjointeffects(x, emmval = 1, ...)
}
\arguments{
\item{x}{"qgcompemmfit" object from qgcomp.emm.glm.noboot
function}

\item{emmval}{numerical: value of effect measure modifier at which weights are generated}

\item{...}{unused}
}
\value{
An object of class "qgcompemmeffects", which inherits from "qgcompemmfit" and "list"

This class contains the \code{emmval}-stratum specific effect estimates of the mixture. By default, this prints a coefficient table, similar to objects of type "qgcompemmfit" which displays the stratum specific joint effects from a "qgcompemmfit" model.
}
\description{
A standard qgcomp fit with effect measure modification
only estimates effects at the referent (0) level of the modifier (psi1).
This function can be used to estimate a "common referent" parameter that
estimates the effect of being in a non-referent category of the modifier and
increasing exposure by one quantile, relative to no change in exposure in the
referent category of the modifier. This is generally useful for binary exposures
(for a mixture with a set of binary exposures,
this would be the "effect" of being exposed and at the index level of the mediator,
relative to being unexposed in the referent level of the mediator), but it may also
be of interest with more general exposures.
}
\examples{
library(qgcompint)
n = 500
dat <- data.frame(y=rbinom(n, 1, 0.5), cd=runif(n), pb=runif(n),
                  raceth=factor(sample(c("WNH", "BNH", "AMIND"), n, replace=TRUE),
                          levels = c("BNH", "WNH", "AMIND")))
(qfit <- qgcomp.emm.glm.noboot(f=y ~cd + pb, emmvar="raceth",
                           expnms = c('cd', 'pb'), data=dat, q=4,
                           family=binomial()))


# first level of the stratifying variable should be the referent category,
#  which you can set with the "levels" argument to "factor" when
#  cleaning/generating data
levels(dat$raceth)

# stratum specific mixture log-odds ratios
# this one comes straight from the model (psi 1)
getjointeffects(qfit, emmval = "BNH")
# this will coincide with joint effects, since it is in the referent category
getstrateffects(qfit, emmval = "BNH")

# the stratum specific effect for a non-referent category of the EMM
#  will not coincide with the joint effect
getjointeffects(qfit, emmval = "AMIND")
getstrateffects(qfit, emmval = "AMIND")

}
\seealso{
\code{\link[qgcompint]{qgcomp.emm.glm.noboot}} \code{\link[qgcompint]{getstrateffects}}
}
\concept{variance mixtures}
