% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_correlation.R
\name{ldsc}
\alias{ldsc}
\title{LD score regression}
\usage{
ldsc(
  Glist = NULL,
  ldscores = NULL,
  z = NULL,
  b = NULL,
  seb = NULL,
  af = NULL,
  stat = NULL,
  n = NULL,
  intercept = TRUE,
  what = "h2",
  SE.h2 = FALSE,
  SE.rg = FALSE,
  blk = 200
)
}
\arguments{
\item{Glist}{list of information about genotype matrix stored on disk}

\item{ldscores}{vector of LD scores (optional as LD scores are stored within Glist)}

\item{z}{matrix of z statistics for n traits}

\item{b}{matrix of marker effects for n traits if z matrix not is given}

\item{seb}{matrix of standard errors of marker effects for n traits if z matrix not is given}

\item{af}{vector of allele frequencies}

\item{stat}{dataframe with marker summary statistics}

\item{n}{vector of sample sizes for the traits (element i corresponds to column vector i in z matrix)}

\item{intercept}{logical if TRUE the LD score regression includes intercept}

\item{what}{either computation of heritability (what="h2") or genetic correlation between traits (what="rg")}

\item{SE.h2}{logical if TRUE standard errors and significance for the heritability estimates are computed using a block jackknife approach}

\item{SE.rg}{logical if TRUE standard errors and significance for the genetic correlations are computed using a block jackknife approach}

\item{blk}{numeric size of the blocks used in the jackknife estimation of standard error (default = 200)}
}
\value{
Returns a matrix of heritability estimates when what="h2", and if SE.h2=TRUE standard errors (SE) and significance levels (P) are returned. 
        If what="rg" an n-by-n matrix of correlations is returned where the diagonal elements being h2 estimates. 
        If SE.rg=TRUE a list is returned with n-by-n matrices of genetic correlations, estimated standard errors and significance levels.
}
\description{
The ldsc function is used for LDSC analysis
}
\examples{


# Plink bed/bim/fam files
 #bedfiles <- system.file("extdata", paste0("sample_chr",1:2,".bed"), package = "qgg")
 #bimfiles <- system.file("extdata", paste0("sample_chr",1:2,".bim"), package = "qgg")
 #famfiles <- system.file("extdata", paste0("sample_chr",1:2,".fam"), package = "qgg")
 #
 ## Summarize bed/bim/fam files
 #Glist <- gprep(study="Example", bedfiles=bedfiles, bimfiles=bimfiles, famfiles=famfiles)

 #
 ## Filter rsids based on MAF, missingness, HWE
 #rsids <-  gfilter(Glist = Glist, excludeMAF=0.05, excludeMISS=0.05, excludeHWE=1e-12) 
 #
 ## Compute sparse LD (msize=size of LD window)
 ##ldfiles <- system.file("extdata", paste0("sample_chr",1:2,".ld"), package = "qgg")
 ##Glist <- gprep(Glist, task="sparseld", msize=200, rsids=rsids, ldfiles=ldfiles, overwrite=TRUE)
 #
 #
 ##Simulate data
 #W1 <- getG(Glist, chr=1, scale=TRUE)
 #W2 <- getG(Glist, chr=2, scale=TRUE)

 #W <- cbind(W1,W2)
 #causal <- sample(1:ncol(W),5)

 #b1 <- rnorm(length(causal))
 #b2 <- rnorm(length(causal))
 #y1 <- W[, causal]\%*\%b1 + rnorm(nrow(W))
 #y2 <- W[, causal]\%*\%b2 + rnorm(nrow(W))

 #data1 <- data.frame(y = y1, mu = 1)
 #data2 <- data.frame(y = y2, mu = 1)
 #X1 <- model.matrix(y ~ 0 + mu, data = data1)
 #X2 <- model.matrix(y ~ 0 + mu, data = data2)

 ## Linear model analyses and single marker association test
 #maLM1 <- lma(y=y1, X=X1,W = W)
 #maLM2 <- lma(y=y2,X=X2,W = W)
 #
 ## Compute heritability and genetic correlations for trait 1 and 2
 #z1 <- maLM1[,"stat"]
 #z2 <- maLM2[,"stat"]

 #z <- cbind(z1=z1,z2=z2)

 #h2 <- ldsc(Glist, z=z, n=c(500,500), what="h2")
 #rg <- ldsc(Glist, z=z, n=c(500,500), what="rg")



}
\author{
Peter Soerensen

Palle Duun Rohde
}
