% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat-raster.R
\name{qgis_as_raster}
\alias{qgis_as_raster}
\alias{qgis_as_brick}
\alias{qgis_as_raster.qgis_outputRaster}
\alias{qgis_as_brick.qgis_outputRaster}
\alias{qgis_as_raster.qgis_outputLayer}
\alias{qgis_as_brick.qgis_outputLayer}
\alias{qgis_as_raster.qgis_result}
\alias{qgis_as_brick.qgis_result}
\title{Convert a qgis_result object or one of its elements to a raster object}
\usage{
qgis_as_raster(x, ...)

qgis_as_brick(x, ...)

\method{qgis_as_raster}{qgis_outputRaster}(x, ...)

\method{qgis_as_brick}{qgis_outputRaster}(x, ...)

\method{qgis_as_raster}{qgis_outputLayer}(x, ...)

\method{qgis_as_brick}{qgis_outputLayer}(x, ...)

\method{qgis_as_raster}{qgis_result}(x, ...)

\method{qgis_as_brick}{qgis_result}(x, ...)
}
\arguments{
\item{x}{A \code{qgis_result} object from \code{\link[=qgis_run_algorithm]{qgis_run_algorithm()}} or a
\verb{qgis_output*} object from one of the \code{\link[=qgis_extract_output]{qgis_extract_output()}} functions.}

\item{...}{Arguments passed to \code{\link[raster:raster]{raster::raster()}} or \code{\link[raster:brick]{raster::brick()}}.}
}
\value{
A \code{RasterLayer} or a \code{RasterBrick} object.
}
\description{
Convert a qgis_result object or one of its elements to a raster object
}
\examples{
\dontshow{if (has_qgis() && requireNamespace("raster", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# not running below examples in R CMD check to save time
result <- qgis_run_algorithm(
  "native:slope",
  INPUT = system.file("longlake/longlake_depth.tif", package = "qgisprocess")
)

# most direct approach, autoselecting a `qgis_outputRaster` type
# output from the `result` object and reading as RasterLayer:
qgis_as_raster(result)

# if you need more control, extract the needed output element first:
output_raster <- qgis_extract_output(result, "OUTPUT")
qgis_as_raster(output_raster)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other topics about coercing processing output: 
\code{\link{qgis_as_terra}()},
\code{\link{st_as_sf}},
\code{\link{st_as_stars}}

Other topics about accessing or managing processing results: 
\code{\link{qgis_as_terra}()},
\code{\link{qgis_clean_result}()},
\code{\link{qgis_extract_output}()},
\code{\link{qgis_result_status}()},
\code{\link{st_as_sf}},
\code{\link{st_as_stars}}
}
\concept{topics about accessing or managing processing results}
\concept{topics about coercing processing output}
