% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpNCA.r
\name{check.input}
\alias{check.input}
\title{Check qpNCA function arguments for validity}
\usage{
check.input(
  x,
  by = NA,
  nomtimevar = NA,
  timevar = NA,
  depvar = NA,
  bloqvar = NA,
  loqvar = NA,
  loqrule = NA,
  includeCmax = NA,
  exclvar = NA,
  plotdir = NA,
  timelab = NA,
  deplab = NA,
  tau = NA,
  tstart = NA,
  tend = NA,
  teval = NA,
  covariates = NA,
  dose = NA,
  factor = NA,
  reg = NA,
  ss = NA,
  route = NA,
  method = NA
)
}
\arguments{
\item{x}{data.frame}

\item{by}{column names in x indicating grouping variables}

\item{nomtimevar}{variable name containing the nominal sampling time after dose}

\item{timevar}{variable name containing the actual sampling time after dose}

\item{depvar}{variable name containing the dependent variable (e.g., concentration)}

\item{bloqvar}{variable name containing the BLOQ flag (0: no, 1: yes)}

\item{loqvar}{variable name containing the LOQ value}

\item{loqrule}{rule number to be applied to the LOQ values in the curve; x$loqrule overrides if provided}

\item{includeCmax}{include Cmax in half-life estimation? (y/n); x$includeCmax overrides if provided}

\item{exclvar}{variable name indicating points to be excluded in half-life estimation (these should have exclvar = 1)}

\item{plotdir}{directory where regression plots (.PNG) will be saved; NA gives default location, NULL skips regression plots}

\item{timelab}{label for time axis in regression plots}

\item{deplab}{label for dependent variable axis in regression plots}

\item{tau}{dosing interval (for multiple dosing); NA (default) if single dose; x$tau overrides}

\item{tstart}{start time of partial AUC (start>0); NA (default) if not requested; x$tstart overrides}

\item{tend}{end time of partial AUC; NA (default) if not requested; x$tend overrides}

\item{teval}{user selected AUC interval (starting at t=0); NA (default) if not requested; x$teval overrides}

\item{covariates}{covariates dataset; Must contain the dose variable}

\item{dose}{variable containing the dose amount}

\item{factor}{conversion factor for CL and V calculation (e.g. dose in mg, conc in ng/mL, factor=1000); x$factor overrides if provided}

\item{reg}{regimen, "SD" or "MD"; x$reg overrides if provided}

\item{ss}{is steady state reached (y/n); x$ss overrides if provided}

\item{route}{route of drug administration ("EV","IVB", "IVI"); x$route overrides if provided}

\item{method}{method for trapezoidal rule; x$method overrides if provided}
}
\value{
Check results
}
\description{
Checks whether all function arguments are valid and entered column names are present in input data \cr
See \code{\link{qpNCA}} for description of the arguments
}
