% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_new_functions.R
\name{gp_label}
\alias{gp_label}
\title{Create a general-purpose (gp) label with text aligned in a landscape orientation.}
\usage{
gp_label(
  dat,
  get_unique_id = c("uuid", "custom"),
  unique_id = NULL,
  filename = "PlotLabel",
  top_left_txt1 = NULL,
  top_left_txt2 = NULL,
  top_right_txt1 = NULL,
  top_right_txt2 = NULL,
  center_right_txt1 = NULL,
  center_right_txt2 = NULL,
  center_right_txt3 = NULL,
  bottom_left_txt1 = NULL,
  bottom_left_txt2 = NULL,
  top_left_id1 = NULL,
  top_left_id2 = NULL,
  top_right_id1 = NULL,
  top_right_id2 = NULL,
  center_right_id1 = NULL,
  center_right_id2 = NULL,
  center_right_id3 = NULL,
  bottom_left_id1 = NULL,
  bottom_left_id2 = NULL,
  ...
)
}
\arguments{
\item{dat}{An input data frame or field book that contains plot or label attributes.
The order of the columns is not important, and the columns can be any name 
the user desires.}

\item{get_unique_id}{Set to 'uuid' if universal unique ids are to be generated.}

\item{unique_id}{The column identifier in \code{dat} containing unique identifiers or strings to generate QR codes.
Set to 'custom' if imported field book already has unique IDs for each plot.}

\item{filename}{A character prefix or path for the pdf file to be created. Default path
is working directory.}

\item{top_left_txt1}{The prefix text for top-left row 1.}

\item{top_left_txt2}{The prefix text for top-left row 2.}

\item{top_right_txt1}{The prefix text for the top-right row 1.}

\item{top_right_txt2}{The prefix text for the top-right row 2.}

\item{center_right_txt1}{The prefix text for center-right row 1.}

\item{center_right_txt2}{The prefix text for center-right row 2.}

\item{center_right_txt3}{The prefix text for center-right row 3.}

\item{bottom_left_txt1}{The column identifier in \code{dat} containing text for bottom-left row 1.}

\item{bottom_left_txt2}{The column identifier in \code{dat} containing text for bottom-left row 2.}

\item{top_left_id1}{The column identifier in \code{dat} containing text for top-left row 1.}

\item{top_left_id2}{The column identifier in \code{dat} containing text for top-left row 2.}

\item{top_right_id1}{The column identifier in \code{dat} containing text for top-right row 1.}

\item{top_right_id2}{The column identifier in \code{dat} containing text for top-right row 2.}

\item{center_right_id1}{The column identifier in \code{dat} containing text for center-right row 1.}

\item{center_right_id2}{The column identifier in \code{dat} containing text for center-right row 2.}

\item{center_right_id3}{The column identifier in \code{dat} containing text for center-right row 3.}

\item{bottom_left_id1}{The column identifier in \code{dat} containing text for bottom-left row 1.}

\item{bottom_left_id2}{The column identifier in \code{dat} containing text for bottom-left row 2.}

\item{...}{Additional arguments passed to the \code{create_label} function.}
}
\value{
A PDF file containing plot labels affixed with QR codes, and a data frame of
 an updated field book; all saved to the default or working directory.
}
\description{
This is a wrapper that gives more flexibility to the user to design 
any general-purpose label affixed with QR codes. It gives nine(9) text 
positions in landscape orientation that can be filled with human-readable text
items as specified by the user. Arguments are passed to the `create_label()` function.
}
\examples{
library(qrlabelr)
df <- data.frame(LOCATION = rep("BAMBEY", 5),
                 PLOT = 1001:1005,
                 ROW = c(rep(1, 3), rep(2, 2)),
                 COLUMN = c(1:3, 1:2),
                 REP = rep(1, 5),
                 IBLOCK = c(rep(1, 3), rep(2, 2)),
                 TREATMENT = paste0("G-", 1:5),
                 SEED_SOURCE = rep("OFF_NUR", 5))

df$ids <- paste0(df$LOCATION,'2023', '_PYT', '_', df$PLOT, '_', df$ROW, '_',
                 df$COLUMN)
file <- tempfile()
\donttest{
if(file.exists(file)) 
gp_label(dat = df,
         wdt = 5,
         hgt = 2,
         page_wdt = 8.5,
         page_hgt = 11,
         top_mar = 0.75,
         bot_mar = 0.75,
         left_mar = 1.75,
         right_mar = 1.75,
         numrow = 4L,
         numcol = 1L,
         filename = file,
         font_sz = 20,
         rname = "Adoma",
         get_unique_id = "custom",
         unique_id = 'ids',
         family = "sans",
         top_left_txt1 = 'Plot:',
         top_left_txt2 = 'Row:',
         top_right_txt1 = 'Rep:',
         top_right_txt2 = 'Col:',
         center_right_txt1 = 'iBlock:',
         center_right_txt2 = 'Seed:',
         center_right_txt3 = 'Adoma',
         top_left_id1 = 'PLOT',
         top_left_id2 = 'ROW',
         top_right_id1 = 'REP',
         top_right_id2 = 'COLUMN',
         center_right_id1 = 'IBLOCK',
         center_right_id2 = 'SEED_SOURCE',
         bottom_left_id1 = 'ids',
         bottom_left_id2 = 'TREATMENT',
         ec_level = 1)
}

}
\seealso{
\code{\link{create_label}} and \code{\link{field_label}}
}
