% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsavem-load.R
\name{qsavem}
\alias{qsavem}
\title{qsavem}
\usage{
qsavem(file, ...)
}
\arguments{
\item{file}{the file name/path.}

\item{...}{objects to serialize. Named arguments will be passed to qsave during saving. Un-named arguments will be saved.}
}
\description{
Saves (serializes) multiple objects to disk.
}
\details{
This function extends qsave to replicate the functionality of base::save to save multiple objects. Read them back with qload.
}
\examples{
x1 <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
x2 <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
myfile <- tempfile()
qsavem(x1, x2, file=myfile)
rm(x1, x2)
qload(myfile)
exists(c('x1', 'x2')) # returns true

# qs support multithreading
qsavem(x1, x2, file=myfile, nthreads=2)
rm(x1, x2)
qload(myfile, nthreads=2)
exists(c('x1', 'x2')) # returns true
}
