% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qd_deserialize}
\alias{qd_deserialize}
\title{qd_deserialize}
\usage{
qd_deserialize(input, use_alt_rep = FALSE, validate_checksum = FALSE, nthreads = 1L)
}
\arguments{
\item{input}{The raw vector to deserialize.}

\item{use_alt_rep}{Use ALTREP when reading in string data (default \code{FALSE}).}

\item{validate_checksum}{Whether to validate the stored checksum in the file (default \code{FALSE}). This can be used to test for file corruption but has a performance penality.}

\item{nthreads}{The number of threads to use when reading data (default: \code{1}).}
}
\value{
The deserialized object.
}
\description{
Deserializes a raw vector to an object using the \code{qdata} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
        num = rnorm(1e3),
        char = sample(state.name, 1e3, replace=TRUE),
        stringsAsFactors = FALSE)
xserialized <- qd_serialize(x)
x2 <- qd_deserialize(xserialized)
identical(x, x2) # returns true
}
