% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cross2.R
\name{check_cross2}
\alias{check_cross2}
\title{Check a cross2 object}
\usage{
check_cross2(cross2)
}
\arguments{
\item{cross2}{An object of class \code{"cross2"}, as output by \code{\link[=read_cross2]{read_cross2()}}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}
}
\value{
If everything is correct, returns \code{TRUE}; otherwise \code{FALSE},
with attributes that give the problems.
}
\description{
Check the integrity of the data within a cross2 object.
}
\details{
Checks whether a cross2 object meets the
specifications. Problems are issued as warnings.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
check_cross2(grav2)
}
