% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_genes.R
\name{plot_genes}
\alias{plot_genes}
\title{Plot gene locations for a genomic interval}
\usage{
plot_genes(
  genes,
  minrow = 4,
  padding = 0.2,
  colors = c("black", "red3", "green4", "blue3", "orange"),
  scale_pos = 1,
  start_field = "start",
  stop_field = "stop",
  strand_field = "strand",
  name_field = "Name",
  ...
)
}
\arguments{
\item{genes}{Data frame containing \code{start} and \code{stop} in
Mbp, \code{strand} (as \code{"-"}, \code{"+"}, or \code{NA}), and
\code{Name}.}

\item{minrow}{Minimum number of rows of genes in the plot}

\item{padding}{Proportion to pad with white space around the genes}

\item{colors}{Vectors of colors, used sequentially and then re-used.}

\item{scale_pos}{Factor by which to scale position (for example, to convert basepairs to Mbp)}

\item{start_field}{Character string with name of column containing the genes' start positions.}

\item{stop_field}{Character string with name of column containing the genes' stop positions.}

\item{strand_field}{Character string with name of column containing the genes' strands.}

\item{name_field}{Character string with name of column containing the genes' names.}

\item{...}{Optional arguments passed to \code{plot()}.}
}
\value{
None.
}
\description{
Plot gene locations for a genomic interval, as rectangles with gene
symbol (and arrow indicating strand/direction) below.
}
\section{Hidden graphics parameters}{

Graphics parameters can be passed via \code{...}. For
example, \code{xlim} to control the x-axis limits.
These are not included as formal
}

\examples{
genes <- data.frame(chr = c("6", "6", "6", "6", "6", "6", "6", "6"),
                    start = c(139988753, 140680185, 141708118, 142234227, 142587862,
                              143232344, 144398099, 144993835),
                    stop  = c(140041457, 140826797, 141773810, 142322981, 142702315,
                              143260627, 144399821, 145076184),
                    strand = c("-", "+", "-", "-", "-", NA, "+", "-"),
                    Name = c("Plcz1", "Gm30215", "Gm5724", "Slco1a5", "Abcc9",
                             "4930407I02Rik", "Gm31777", "Bcat1"),
                    stringsAsFactors=FALSE)

# use scale_pos=1e-6 because data in bp but we want the plot in Mbp
plot_genes(genes, xlim=c(140, 146), scale_pos=1e-6)
}
\keyword{hgraphics}
