% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind_sim_geno.R
\name{cbind.sim_geno}
\alias{cbind.sim_geno}
\title{Join genotype imputations for different chromosomes}
\usage{
\method{cbind}{sim_geno}(...)
}
\arguments{
\item{...}{Genotype imputation objects as produced by
\code{\link[=sim_geno]{sim_geno()}}. Must have the same set of individuals.}
}
\value{
An object of class \code{"sim_geno"}, like the input; see \code{\link[=sim_geno]{sim_geno()}}.
}
\description{
Join multiple genotype imputation objects, as produced by
\code{\link[=sim_geno]{sim_geno()}}, for the same individuals but different
chromosomes.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
drawsA <- sim_geno(grav2[1:5,1:2], map, error_prob=0.002, n_draws=4)
drawsB <- sim_geno(grav2[1:5,3:4], map, error_prob=0.002, n_draws=4)
draws <- cbind(drawsA, drawsB)

}
\seealso{
\code{\link[=rbind.sim_geno]{rbind.sim_geno()}}, \code{\link[=sim_geno]{sim_geno()}}
}
