% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_merge_feature.R, R/merge_feature.R
\name{ggplot_merge_feature}
\alias{ggplot_merge_feature}
\alias{autoplot.merge_feature}
\alias{merge_feature}
\alias{summary.merge_feature}
\title{Plot of merge_feature object}
\usage{
ggplot_merge_feature(x, pheno, plot_by = c("pattern", "consequence"), ...)

\method{autoplot}{merge_feature}(x, ...)

merge_feature(
  top_snps_tbl,
  snpinfo,
  out_lmm_snps,
  drop = 1.5,
  dropchar = 0,
  exons = gene_exon(top_snps_tbl)
)

\method{summary}{merge_feature}(object, sum_type = c("SNP type", "pattern"), ...)
}
\arguments{
\item{x}{of class \code{merge_feature}}

\item{pheno}{name of phenotype to be plotted}

\item{plot_by}{element to plot by (one of \code{c("pattern","consequence")})}

\item{...}{other arguments not used}

\item{top_snps_tbl}{tbl from \code{\link{top_snps_pattern}} or \code{\link[qtl2]{top_snps}}}

\item{snpinfo}{SNP information table}

\item{out_lmm_snps}{tbl from \code{\link[qtl2]{scan1}} on SNPs}

\item{drop}{include LOD scores within \code{drop} of max for each phenotype}

\item{dropchar}{number of characters to drop on phenames}

\item{exons}{table from \code{\link{gene_exon}}}

\item{object}{of class \code{merge_feature}}

\item{sum_type}{one of \code{c("SNP type","pattern")}}
}
\value{
ggplot2 object

tbl with added information on genes and exons

table summary
}
\description{
Merge all SNPs in small region with LOD peaks across multiple phenotype.
}
\examples{
dirpath <- "https://raw.githubusercontent.com/rqtl/qtl2data/master/DOex"

# Read DOex example cross from 'qtl2data'
DOex <- subset(qtl2::read_cross2(file.path(dirpath, "DOex.zip")), chr = "2")

\donttest{
# Download genotype probabilities
tmpfile <- tempfile()
download.file(file.path(dirpath, "DOex_genoprobs_2.rds"), tmpfile, quiet=TRUE)
pr <- readRDS(tmpfile)
unlink(tmpfile)

# Download SNP info for DOex from web and read as RDS.
tmpfile <- tempfile()
download.file(file.path(dirpath, "c2_snpinfo.rds"), tmpfile, quiet=TRUE)
snpinfo <- readRDS(tmpfile)
unlink(tmpfile)
snpinfo <- dplyr::rename(snpinfo, pos = pos_Mbp)

# Convert to SNP probabilities
snpinfo <- qtl2::index_snps(DOex$pmap, snpinfo)
snppr <- qtl2::genoprob_to_snpprob(pr, snpinfo)

# Scan SNPs.
scan_snppr <- qtl2::scan1(snppr, DOex$pheno)

# Collect top SNPs
top_snps_tbl <- top_snps_pattern(scan_snppr, snpinfo)
summary(top_snps_tbl)

# Download Gene info for DOex from web via RDS
tmpfile <- tempfile()
download.file(file.path(dirpath, "c2_genes.rds"), tmpfile, quiet=TRUE)
gene_tbl <- readRDS(tmpfile)
unlink(tmpfile)

out <- merge_feature(top_snps_tbl, snpinfo, scan_snppr, exons = gene_tbl)
summary(out, "pattern")
}

}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{hplot}
\keyword{utilities}
