% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iboxplot.R
\name{iboxplot}
\alias{iboxplot}
\title{Modern boxplot linked to underlying histrograms}
\usage{
iboxplot(dat, qu = c(0.001, 0.01, 0.1, 0.25), orderByMedian = TRUE,
  breaks = 251, chartOpts = NULL, digits = 5)
}
\arguments{
\item{dat}{Data matrix (individuals x variables)}

\item{qu}{Quantiles to plot (All with 0 < qu < 0.5)}

\item{orderByMedian}{If TRUE, reorder individuals by their median}

\item{breaks}{Number of bins in the histograms, or a vector of
locations of the breakpoints between bins (as in \code{\link[graphics]{hist}})}

\item{chartOpts}{A list of options for configuring the chart (see
the coffeescript code). Each element must be named using the
corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph for a large set of box plots (rendered
as lines connecting the quantiles), linked to underlying histograms.
}
\examples{
n.ind <- 500
n.gene <- 10000
expr <- matrix(rnorm(n.ind * n.gene, (1:n.ind)/n.ind*3), ncol=n.gene)
dimnames(expr) <- list(paste0("ind", 1:n.ind),
                       paste0("gene", 1:n.gene))
\donttest{
iboxplot(expr, chartOpts=list(xlab="Mice", ylab="Gene expression"))}

}
\seealso{
\code{\link{iplotCorr}}, \code{\link{scat2scat}}
}
\keyword{hplot}
