% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcp.R
\name{summarize_lcps}
\alias{summarize_lcps}
\alias{summarize_lcps,LcpFinder-method}
\title{Get a matrix summarizing all LCPs found by a \code{LcpFinder}}
\usage{
\S4method{summarize_lcps}{LcpFinder}(x)
}
\arguments{
\item{x}{a \code{\link{LcpFinder}}}
}
\value{
Returns a nine-column matrix with one row for each LCP (and therefore
  one row per destination cell). The columns are as follows:
  \itemize{
     \item{\code{id}: }{the ID of the destination cell}
     \item{\code{xmin, xmax, ymin, ymax}: }{the extent of the destination
     cell}
     \item{\code{value}: }{the value of the destination cell}
     \item{\code{area}: }{the area of the destination cell}
     \item{\code{lcp_cost}: }{the cumulative cost of the LCP to this cell}
     \item{\code{lcp_dist}: }{the cumulative distance of the LCP to this cell
     - note that this is not straight-line distance, but instead the distance
     along the path} }
}
\description{
Given a \code{\link{LcpFinder}}, returns a matrix that
  summarizes all of the LCPs that have been calculated by the
  \code{\link{LcpFinder}}.
}
\details{
Note that this function returns \strong{all} of the paths that have
  been calculated. Finding one LCP likely involves finding other LCPs as
  well. Thus, even if the \code{\link{LcpFinder}} has been used to find one
  LCP, others have most likely been calculated. This function returns all of
  the LCPs that have been calculated so far.
}
\examples{
library(quadtree)
data(habitat)

qt <- quadtree(habitat, split_threshold = .1, adj_type = "expand")

start_pt <- c(19000, 25000)
end_pt <- c(33015, 38162)

# find LCP from 'start_pt' to 'end_pt'
lcpf <- lcp_finder(qt, start_pt)
lcp <- find_lcp(lcpf, end_pt)

# retrieve ALL the paths that have been calculated
paths <- summarize_lcps(lcpf)
head(paths)
}
\seealso{
\code{\link{lcp_finder}()} creates the \code{\link{LcpFinder}}
  object used as input to this function. \code{\link{find_lcp}()} returns the
  LCP between the start point and another point. \code{\link{find_lcps}()}
  calculates all LCPs whose cost-distance is less than some value.
}
