% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_distribution_history.R
\name{fetch_distribution_history}
\alias{fetch_distribution_history}
\title{Download distribution history data for a distribution from Qualtrics}
\usage{
fetch_distribution_history(distributionID)
}
\arguments{
\item{distributionID}{String. Unique distribution ID for the distribution history you want to download.}
}
\description{
Download distribution history data for a distribution from Qualtrics
}
\details{
If the request to the Qualtrics API made by this function fails, the request
will be retried. If you see these failures on a 500 error (such as a 504
error) be patient while the request is retried; it will typically succeed
on retrying. If you see other types of errors, retrying is unlikely to help.
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
qualtrics_api_credentials(
  api_key = "<YOUR-API-KEY>",
  base_url = "<YOUR-BASE-URL>"
)

surveys <- all_surveys()
distributions <- fetch_distributions(surveys$id[1])
distribution_history <- fetch_distribution_history(distributions$id[1])
}

}
