% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions.R
\name{MDA}
\alias{MDA}
\title{Mean Difference Analog (MDA)}
\usage{
MDA(x, na.rm = TRUE)
}
\arguments{
\item{x}{a vector of frequencies}

\item{na.rm}{if TRUE, missing values are removed. If FALSE, NA is returned if there is any NA value.}
}
\value{
The value of the MDA statistics, which is normalised (varies between
  0 and 1).
}
\description{
Computes the mean difference analog (MDA) for a vector of frequencies of
categories.
}
\details{
According to Wilcox (1973, p. 328), the MDA is 'an analog of the mean
difference, a measure of variation that is discussed and used much less
frequently than the average deviation or the standard deviation. It is
defined as "the average of the differences of all the possible pairs of
variate-values, taken regardless of sign"'. The formula for the MDA is:
\deqn{1 - \frac{\sum_{i=1}^{k-1} \sum_{j=i+1}^k |f_i - f_j|}{N(K-1)}}
}
\examples{
x <- rmultinom(1, 100, rep_len(0.25, 4))
x <- as.vector(t(x))
MDA(x)

df <- rmultinom(10, 100, rep_len(0.25, 4))
df <- as.data.frame(t(df))
apply(df, 1, MDA)
}
\references{
Wilcox, Allen R. 'Indices of Qualitative Variation and Political
  Measurement.' \emph{The Western Political Quarterly} 26, no. 2 (1 June
  1973): 325-43. doi:10.2307/446831.
}

