% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneSampleSingleSidedVolcano.R
\name{plotOneSideVolcano}
\alias{plotOneSideVolcano}
\title{Plot and filter data coming from one sample single sided t-test}
\usage{
plotOneSideVolcano(data, p.thresh = 0.05, fc.thresh = 2, main = "")
}
\arguments{
\item{data}{- matrix generated by onesamplegreaterT}

\item{p.thresh}{- p value to filter with, default 0.05}

\item{fc.thresh}{- fold change threshold to filter with, default 2}

\item{main}{- main title of plot}
}
\description{
Plot and filter data coming from one sample single sided t-test
}
\examples{

data <- matrix(rnorm(100,1,1), ncol=5)
dim(data)
rownames(data) <- 1:20
resM <- onesamplegreaterT(data)
plotOneSideVolcano(resM)
data <- matrix(rnorm(100,2,1), ncol=5)
dim(data)
rownames(data) <- 1:20
resM <- onesamplegreaterT(data)
plotOneSideVolcano(resM)
}
