% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinTokens.R
\name{joinTokens}
\alias{joinTokens}
\title{join tokens function}
\usage{
joinTokens(x, sequences, concatenator = "-", valuetype = "fixed",
  verbose = FALSE)
}
\arguments{
\item{x}{some object}

\item{sequences}{list of vector of features to concatenate}

\item{concatenator}{character used for joining tokens}

\item{valuetype}{how to interpret sequences: \code{fixed} for words as
is; \code{"regex"} for regular expressions; or \code{"glob"} for
"glob"-style wildcard}

\item{verbose}{display progress}
}
\description{
Needs some more explanation
}
\examples{
toks <- tokenize(inaugCorpus, removePunct = TRUE)
seqs_token <- list(c('foreign', 'policy'), c('United', 'States'))
seqs_glob <- list(c('foreign', 'polic*'), c('United', 'States'))
seqs_regex <- list(c('^foreign', '^polic(ie|y)'), c('^United', '^States'))
toks2 <- joinTokens(toks, seqs_token, "_", 'glob')
toks2 <- joinTokens(toks, seqs_glob, "_", 'glob')
toks2 <- joinTokens(toks, seqs_regex, "_", 'regex')
kwic(toks2, 'foreign_policy', window=1) # joined
kwic(toks2, c('foreign', 'policy'), window=1) # not joined
kwic(toks2, 'United_States', window=1) # joined
}

