% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nscrabble.R
\name{nscrabble}
\alias{nscrabble}
\title{count the Scrabble letter values of text}
\usage{
nscrabble(x, FUN = sum)
}
\arguments{
\item{x}{a character vector}

\item{FUN}{function to be applied to the character values in the text; 
default is \code{sum}, but could also be \code{mean} or a user-supplied 
function}
}
\value{
a (named) integer vector of Scabble letter values, computed using 
  \code{FUN}, corresponding to the input text(s)
}
\description{
Tally the Scrabble letter values of text given a user-supplied function, 
such as the sum (default) or mean of the character values.
}
\note{
Character values are only defined for non-accented Latin a-z, A-Z 
  letters.  Lower-casing is unnecessary.
}
\examples{
nscrabble(c("muzjiks", "excellency"))
nscrabble(data_char_inaugural[1:5], mean)
}
\author{
Kenneth Benoit
}
