% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_replace.R
\name{dfm_replace}
\alias{dfm_replace}
\title{Replace features in dfm}
\usage{
dfm_replace(x, pattern, replacement = NULL, case_insensitive = TRUE,
  verbose = quanteda_options("verbose"))
}
\arguments{
\item{x}{\link{dfm} whose features will be replaced}

\item{pattern}{a character vector or \link{dictionary}.  See \link{pattern}
for more details.}

\item{replacement}{if \code{pattern} is a character vector, then
\code{replacement} must be character vector of equal length, for a 1:1
match.  If \code{pattern} is a \link{dictionary}, then \code{replacement}
should not be used.}

\item{case_insensitive}{ignore case when matching, if \code{TRUE}}

\item{verbose}{print status messages if \code{TRUE}}
}
\description{
Substitute features based on vectorized one-to-one matching for lemmatization
or user-defined stemming.
}
\examples{
mydfm <- dfm(data_corpus_irishbudget2010)

# lemmatization
infle <- c("foci", "focus", "focused", "focuses", "focusing", "focussed", "focusses")
lemma <- rep("focus", length(infle))
mydfm2 <- dfm_replace(mydfm, infle, lemma)
featnames(dfm_select(mydfm2, infle))

# stemming
feat <- featnames(mydfm)
stem <- char_wordstem(feat, "porter")
mydfm3 <- dfm_replace(mydfm, feat, stem, case_insensitive = FALSE)
identical(mydfm3, dfm_wordstem(mydfm, "porter"))
}
