% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_lsa.R
\name{textmodel_lsa}
\alias{textmodel_lsa}
\title{Latent Semantic Analysis}
\usage{
textmodel_lsa(x, nd = 10, margin = c("both", "documents", "features"))
}
\arguments{
\item{x}{the \link{dfm} on which the model will be fit}

\item{nd}{the number of dimensions to be included in output}

\item{margin}{margin to be smoothed by the SVD}
}
\description{
Fit the Latent Semantic Analysis scaling model to a \link{dfm}, which may be
weighted (for instance using \code{\link{dfm_tfidf}}).
}
\details{
\link[RSpectra]{svds} in the \pkg{RSpectra} package is applied to 
  enable the fast computation of the SVD.
}
\note{
The number of dimensions \code{nd} retained in LSA is an empirical
  issue. While a reduction in \eqn{k} can remove much of the noise, keeping
  too few dimensions or factors may lose important information.
}
\examples{
ie_dfm <- dfm(data_corpus_irishbudget2010)
# create an LSA space and return its truncated representation in the low-rank space
ie_lsa <- textmodel_lsa(ie_dfm[1:10, ])
head(ie_lsa$docs)

# matrix in low_rank LSA space
ie_lsa$matrix_low_rank[,1:5]

# fold queries into the space generated by ie_dfm[1:10,]
# and return its truncated versions of its representation in the new low-rank space
new_lsa <- predict(ie_lsa, ie_dfm[11:14, ])
new_lsa$docs_newspace

}
\references{
Rosario, Barbara.  2000.
  "\href{http://www.cse.msu.edu/~cse960/Papers/LSI/LSI.pdf}{Latent 
  Semantic Indexing: An overview}". \emph{Technical report INFOSYS 240 Spring
  Paper, University of California, Berkeley.}
  
  Deerwester, S., Dumais, S. T., Furnas, G. W., Landauer, T. K., & Harshman, 
  R. 1990. 
  "\href{https://search.proquest.com/docview/1301252034}{Indexing
  by latent semantic analysis}". \emph{Journal of the American society for 
  information science} 41(6), 391.
}
\seealso{
\code{\link{predict.textmodel_lsa}}, \code{\link{coef.textmodel_lsa}}
}
\author{
Haiyan Wang and Kohei Watanabe
}
\keyword{experimental}
\keyword{textmodel}
