% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object-builder.R
\name{object-builders}
\alias{object-builders}
\alias{build_dfm}
\alias{rebuild_dfm}
\alias{upgrade_dfm}
\alias{build_tokens}
\alias{rebuild_tokens}
\alias{upgrade_tokens}
\alias{build_corpus}
\alias{rebuild_corpus}
\alias{upgrade_corpus}
\alias{build_dictionary2}
\alias{rebuild_dictionary2}
\alias{upgrade_dictionary2}
\alias{build_fcm}
\alias{rebuild_fcm}
\alias{upgrade_fcm}
\title{Object builders}
\usage{
build_dfm(
  x,
  features,
  docvars = data.frame(),
  meta = list(),
  class = "dfm",
  ...
)

rebuild_dfm(x, attrs)

upgrade_dfm(x)

build_tokens(
  x,
  types,
  padding = FALSE,
  docvars = data.frame(),
  meta = list(),
  class = "tokens",
  ...
)

rebuild_tokens(x, attrs)

upgrade_tokens(x)

build_corpus(x, docvars = data.frame(), meta = list(), class = "corpus", ...)

rebuild_corpus(x, attrs)

upgrade_corpus(x)

build_dictionary2(x, meta = list(), class = "dictionary2", ...)

rebuild_dictionary2(x, attrs)

upgrade_dictionary2(x)

build_fcm(
  x,
  features1,
  features2 = features1,
  meta = list(),
  class = "fcm",
  ...
)

rebuild_fcm(x, attrs)

upgrade_fcm(x)
}
\arguments{
\item{x}{an input \link{corpus}, \link{tokens}, \link{dfm}, \link{fcm} or \link{dictionary} object.}

\item{features}{character for feature of resulting \code{dfm}.}

\item{docvars}{data.frame for document level variables created by
\code{\link[=make_docvars]{make_docvars()}}. Names of documents are extracted from the
\code{docname_} column.}

\item{meta}{list for meta fields}

\item{class}{class labels to be attached to the object.}

\item{...}{values saved in the object meta fields. They overwrite values
passed via \code{meta}. If not specified, default values in
\code{\link[=make_meta]{make_meta()}} will be used.}

\item{attrs}{a list of attributes to be reassigned}

\item{types}{character for types of resulting the \code{tokens} object.}

\item{padding}{logical indicating if the \code{tokens} object contains paddings.}

\item{features1}{character for row feature of resulting \code{fcm}.}

\item{features2}{character for column feature of resulting \code{fcm} iff.
different from \code{feature1}}
}
\description{
Functions to build or re-build core objects, or to upgrade earlier versions
of these objects to the current format.
}
\examples{
quanteda:::build_tokens(
    list(c(1, 2, 3), c(4, 5, 6)),
    docvars = quanteda:::make_docvars(n = 2L),
    types = c("a", "b", "c", "d", "e", "f"),
    padding = FALSE
)
quanteda:::build_corpus(
    c("a b c", "d e f"),
    docvars = quanteda:::make_docvars(n = 2L),
    unit = "sentence"
)
}
\keyword{internal}
