\name{ranks}
\alias{ranks}
\title{
Quantile Regression Ranks
}
\description{
Function to compute ranks from the dual (regression rankscore) process.
}
\usage{
ranks(v, score="wilcoxon", tau=0.5)
}
\arguments{
\item{v}{
  object of class \code{"rq.process"} generated by \code{rq()}
}
\item{score}{
  The score function desired.  Currently  implemented score  functions  
  are \code{"wilcoxon"}, \code{"normal"}, and \code{"sign"}
  which are asymptotically optimal  for  
  the  logistic,  Gaussian  and Laplace location shift models respectively.
  The "normal" score  function is also sometimes called van der Waerden scores.
  Also implemented are the \code{"tau"} which generalizes sign scores to an
  arbitrary quantile, and \code{"interquartile"} which is appropriate
  for tests of scale shift.
}
\item{tau}{
  the optional value of \code{tau} if the \code{"tau"} score function is used.
}}
\value{
The function returns two components. One is the ranks,  the
other is a scale factor which is the \eqn{L_2} norm of the score
function.  All score functions should be normalized to have mean zero.
}
\details{
  See GJKP(1993) for further details.
}
\references{
  Gutenbrunner, C., J. Jureckova,  Koenker, R. and  Portnoy,
  S. (1993)  Tests  of linear hypotheses  based on regression
  rank scores, \emph{Journal of  Nonparametric  Statistics},  (2), 307--331.
}
\seealso{
  \code{\link{rq}}, \code{\link{rq.test.rank}} \code{\link{anova.rq}}
}
\examples{
data(stackloss)
ranks(rq(stack.loss ~ stack.x, tau=-1))
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.
