% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{describe_ml}
\alias{describe_ml}
\title{Multilevel Descriptive Statistics}
\usage{
describe_ml(
  data,
  vrb.nm,
  grp.nm,
  na.rm = TRUE,
  interp = FALSE,
  skew = TRUE,
  ranges = TRUE,
  trim = 0.1,
  type = 3,
  quant = NULL,
  IQR = FALSE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variable columns.}

\item{grp.nm}{character vector of length 1 of a colname from \code{data}
specifying the grouping column.}

\item{na.rm}{logical vector of length 1 specifying whether missing values
should be removed before calculating the descriptive statistics. See
\code{psych::describe}.}

\item{interp}{logical vector of length 1 specifying whether the median should
be standard (FALSE) or interpolated (TRUE).}

\item{skew}{logical vector of length 1 specifying whether skewness and
kurtosis should be calculated (TRUE) or not (FALSE).}

\item{ranges}{logical vector of length 1 specifying whether the minimum,
maximum, and range (i.e., maximum - minimum) should be calculated (TRUE) or
not (FALSE). Note, if \code{ranges} = FALSE, the trimmed mean and median
absolute deviation is also not computed as per the \code{psych::describe}
function behavior.}

\item{trim}{numeric vector of length 1 specifying the top and bottom
quantiles of data that are to be excluded when calculating the trimmed
mean. For example, the default value of 0.1 means that only data within the
10th - 90th quantiles are used for calculating the trimmed mean.}

\item{type}{numeric vector of length 1 specifying the type of skewness and
kurtosis coefficients to compute. See the details of
\code{psych::describe}. The options are 1, 2, or 3.}

\item{quant}{numeric vector specifying the quantiles to compute. Foe example,
the default value of c(0.25, 0.75) computes the 25th and 75th quantiles of
the group number of cases. If \code{quant} = NULL, then no quantiles are
returned.}

\item{IQR}{logical vector of length 1 specifying whether to compute the
Interquartile Range (TRUE) or not (FALSE), which is simply the 75th quantil
- 25th quantile.}
}
\value{
list of two elements each containing a data.frame of descriptive
  statistics, the first for the within-person components ("within") and the
  second for the between-person components ("between").
}
\description{
\code{describe_ml} decomposes descriptive statistics from multilevel data
into within-group and between-group descriptives. The data is first separated
out into within-group components via \code{centers_by} and between-group
components via \code{aggs}. Then the \code{psych} function
\code{\link[psych]{describe}} is applied to both.
}
\examples{

tmp_nm <- c("outcome","case","session","trt_time")
dat <- as.data.frame(lmeInfo::Bryant2016)[tmp_nm]
stats_by <- psych::statsBy(dat, group = "case") # requires you to include "case" column in dat
describe_ml(data = dat, vrb.nm = c("outcome","session","trt_time"), grp.nm = "case")

}
\seealso{
\code{\link[psych]{describe}}
}
