% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{summary_ucfa}
\alias{summary_ucfa}
\title{Summary of a Unidimensional Confirmatory Factor Analysis}
\usage{
summary_ucfa(
  data,
  vrb.nm,
  std.ov = FALSE,
  std.lv = TRUE,
  ordered = FALSE,
  meanstructure = TRUE,
  estimator = "ML",
  se = "standard",
  test = "standard",
  missing = "fiml",
  fit.measures = c("chisq", "df", "tli", "cfi", "rmsea", "srmr"),
  std.load = TRUE,
  resid.type = "cor.bollen",
  add.class = TRUE,
  ...
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} providing the
variables/items}

\item{std.ov}{logical vector of length 1 specifying if the variables/items
should be standardized}

\item{std.lv}{logical vector of length 1 specifying if the latent factor
should be standardized resulting in all factor loadings being estimated. If
FALSE, then the first variable/item in \code{data[vrb.nm]} is fixed to a
factor loading of 1.}

\item{ordered}{logical vector of length 1 specifying if the variables/items
should be treated as ordered categorical items where polychoric
correlations are used.}

\item{meanstructure}{logical vector of length 1 specifying if the mean
structure of the factor model should be estimated. This would be the
variable/item intercepts (and latent factor mean if \code{std.lv} = FALSE).
Note, this must be true to use Full Information Maximum Likelihood (FIML)
to handle missing data via \code{missing} = "fiml".}

\item{estimator}{character vector of length 1 specifying the estimator to use
for parameter estimation. Popular options are 1) "ML" = maximum likelihood
estimation based on the multivariate normal distribution, 2) "DWLS" =
diagonally weighted least squares which uses the diagnonal of the weight
matrix, 3) "WLS" for weighted least squares whiches uses the full weight
matrix (often results in computational problems), 4) "ULS" for unweighted
least squares that doesn't use a weight matrix. "DWLS", "WLS", and "ULS"
can each be used with ordered categorical items when \code{ordered} = TRUE.}

\item{se}{character vector of length 1 specifying how standard errors should
be calculated. Popular options are 1) "standard" for conventional standard
errors from inverting the information matrix, 2) "robust.sem" for robust
standard errors, 3) "robust.huber.white" for sandwich standard errors.}

\item{test}{character vector of length 1 specifying how the omnibus test
statistic should be calculated. Popular options are 1) "standard" for the
conventional chi-square statistic, 2) "Satorra-Bentler" for the
Satorra-Bentler test statistic, 3) "Yaun.Bentler.Mplus" for the version of
the Yuan-Bentler test statistic that Mplus uses, 4) "mean.var.adjusted" for
a mean and variance adjusted test statistic, 5) "scaled.shifted" for the
version of the mean and variance adjusted test statistic Mplus uses.}

\item{missing}{character vector of length 1 specifying how to handle missing
data. Popular options are 1) "fiml" = Full Information Maximum Likelihood
(FIML), 2) "pairwise" = pairwise deletion, 3) "listwise" = listwise
deletion.}

\item{fit.measures}{character vector specifying which model fit indices to
include in the return object. The default option includes the chi-square
test statistic ("chisq"), degrees of freedom ("df"), tucker-lewis index
("tli"), comparative fit index ("cfi"), root mean square error of
approximation ("rmsea"), and standardized root mean residual ("srmr").
Note, if using robust corrections for \code{se} and \code{test}, you will
probably want to call the scaled versions of model fit indices (e.g.,
"chisq.scaled"). See \code{\link[lavaan]{fitMeasures}} for details.}

\item{std.load}{logical vector of length 1 specifying whether the factor
loadings included in the return object should be standardized (TRUE) or not
(FALSE).}

\item{resid.type}{character vector of length 1 specifying the type of
covariance/correlation residuals to include in the return object. Popular
options are 1) "raw" for conventional covariance residuals, 2) "cor.bollen"
for conventional correlation residuals, 3) "cor.bentler" for correlation
residuals that standardizes the model-implied covariance matrix with the
observed variances, 4) "standardized" for conventional z-scores of the
covariance residuals.}

\item{add.class}{logical vector of length 1 specifying whether the lavaan
classes should be added to the returned vectors/matrices (TRUE) or not
(FALSE). These classes do not change the underlying vector/matrix and only
affect printing.}

\item{...}{any other named arguments available in the
\code{\link[lavaan]{cfa}} function. See \code{\link[lavaan]{lavOptions}}
for the list of arguments.}
}
\value{
list of vectors/matrices providing statistical information about
the unidimensional confirmatory factor analysis. If \code{add.class} = TRUE,
then the elements have lavaan classes which affect printing (except for the
first "model_info" element which always is just an integer vector). The four
elements are:

\describe{
   \item{model_info}{integer vector providing model information. The first element
   "converged" is 1 if the model converged and 0 if not. The second element
   "admissible" is 1 if the model is admissible (e.g., no negative variances)
   and 0 if not. The third element "nobs" is the number of observations used
   in the analysis. The fourth element "npar" is the number of parameter estimates.}
   \item{fit_measures}{double vector providing model fit indices. The number
   and names of the fit indices is determined by the \code{fit.measures} argument.}
   \item{factor_load}{1-column double matrix providing factor loadings. The colname
   is "latent" and the rownames are the \code{vrb.nm} argument.}
   \item{cov_resid}{covariance/correlation residuals for the model. Note, even
   though the name has "cov" in it, the residuals can be "cor" if the argument
   \code{resid.type} = "cor.bollen" or "cor.bentler".}
}
}
\description{
\code{summary_ucfa} provides a summary of a unidimensional confirmatory
factor analysis on a set of variables/items. Unidimensional meaning a
one-factor model where all variables/items load on that factor. The function
is a wrapper for \code{\link[lavaan]{cfa}} and returns a list with four
vectors/matrices: 1) model info, 2) fit measures, 3) factor loadings, 4)
covariance/correlation residuals. For details on all the
\code{\link[lavaan]{cfa}} arguments see \code{\link[lavaan]{lavOptions}}.
}
\examples{

# types of models
dat <- psych::bfi[1:250, 16:20] # nueroticism items
summary_ucfa(data = dat, vrb.nm = names(dat)) # default
summary_ucfa(data = dat, vrb.nm = names(dat), estimator = "ML", # MLR
   se = "robust.huber.white", test = "yuan.bentler.mplus", missing = "fiml",
   fit.measures = c("chisq.scaled","df.scaled","tli.scaled","cfi.scaled",
      "rmsea.scaled","srmr"))
summary_ucfa(data = dat, vrb.nm = names(dat), estimator = "ML", # MLM
   se = "robust.sem", test = "satorra.bentler", missing = "listwise",
   fit.measures = c("chisq.scaled","df.scaled","tli.scaled","cfi.scaled",
      "rmsea.scaled","srmr"))
summary_ucfa(data = dat, vrb.nm = names(dat), ordered = TRUE, estimator = "DWLS", # WLSMV
   se = "robust", test = "scaled.shifted", missing = "listwise",
   fit.measures = c("chisq.scaled","df.scaled","tli.scaled","cfi.scaled",
      "rmsea.scaled","wrmr"))

# types of info
dat <- psych::bfi[1:250, 16:20] # nueroticism items
w <- summary_ucfa(data = dat, vrb.nm = names(dat))
x <- summary_ucfa(data = dat, vrb.nm = names(dat), add.class = FALSE)
y <- summary_ucfa(data = dat, vrb.nm = names(dat),
   std.load = FALSE, resid.type = "raw")
z <- summary_ucfa(data = dat, vrb.nm = names(dat),
   std.load = FALSE, resid.type = "raw", add.class = FALSE)
lapply(w, class)
lapply(x, class)
lapply(y, class)
lapply(z, class)

}
\seealso{
\code{\link{ucfa}}
   \code{\link[lavaan]{cfa}}
   \code{\link[lavaan]{lavaan}}
}
