% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_compHist.R
\name{mix.cols.btw}
\alias{mix.cols.btw}
\title{Mix or Blend colors between two or more colors}
\usage{
mix.cols.btw(colors, max = 20, alpha = 1, preview = FALSE)
}
\arguments{
\item{colors}{the vector of two colors}

\item{max}{maximum number of colors to blend between}

\item{alpha}{alpha for the new color blends}

\item{preview}{LOGICAL. preview all color generated}
}
\value{
color hex for all generated colors
}
\description{
Mix or blend multiple colors between two colors
}
\examples{
# simply mix/blend two colors
mix.cols.btw(c("red","brown"))

# simply mix/blend two colors, maximum number of colors at the end
mix.cols.btw(c("red","brown"), max = 8)

# simply mix/blend two colors with alpha=0.2 (opacity=0.2)
mix.cols.btw(c("yellow","green"),alpha = 0.2)

# also preview after mixing the two colors
mix.cols.btw(c("red","green"), preview = TRUE)
mix.cols.btw(c("blue","violet"),alpha = 0.2, preview = TRUE)

mix.cols.btw(c("red","purple","yellow","gray"), preview = TRUE)

mix.cols.btw(c("red","purple","yellow","gray"),alpha = 0.2, preview = TRUE)

}
